/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.importwizard.steps;

import at.ac.ait.speedr.WorkspaceView;
import at.ac.ait.speedr.importwizard.WizardPanel;
import at.ac.ait.speedr.importwizard.WizardValidationException;
import at.ac.ait.speedr.importwizard.steps.DataImportPanel;
import at.ac.ait.speedr.importwizard.steps.ImportTableModel;
import at.ac.ait.speedr.importwizard.steps.OnMemoryZipEntry;
import at.ac.ait.speedr.importwizard.tablemodel.ImportTableModelHelper;
import au.com.bytecode.opencsv.CSVReader;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CSVDataImportWizardStep
implements WizardPanel.ValidatingStep,
WizardPanel.ProgressStep,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(CSVDataImportWizardStep.class.getName());
    public static final String PROP_TABLEMODEL = "TABLEMODEL";
    private DataImportPanel impPanel;
    private WizardPanel settings;
    private boolean valid = false;
    private volatile boolean isStopped = false;
    private File dataFile;
    private OnMemoryZipEntry zippedData;
    private volatile char delimiter;
    private volatile char qualifier;
    private volatile boolean hasColumnNames = false;
    private volatile boolean hasRowNames = false;
    private CSVReaderWorker csvWorker;
    private Zipper zipper;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public DataImportPanel getComponent() {
        if (this.impPanel == null) {
            this.impPanel = new DataImportPanel(true);
            this.impPanel.addPropertyChangeListener(this);
        }
        return this.impPanel;
    }

    public void readSettings(WizardPanel settings) {
        if (this.getComponent().getTableModel().getMaxColumnCount() > 0) {
            this.getComponent().resetRowAndColumnsMaxAndMin();
            this.getComponent().getTableModel().clearAll();
        }
        this.settings = settings;
    }

    public void storeSettings(WizardPanel settings) {
        settings.putProperty("VARIABLENAME", this.getComponent().getVariableName());
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean b) {
        this.valid = b;
        this.fireChangeEvent();
    }

    public synchronized OnMemoryZipEntry getZippedData() {
        return this.zippedData;
    }

    public synchronized void setZippedData(OnMemoryZipEntry zippedData) {
        this.zippedData = zippedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        if (!this.listeners.contains(l)) {
            Set<ChangeListener> set = this.listeners;
            synchronized (set) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "DELIMITER") {
            this.setValid(false);
            this.getComponent().setConfigurationPanelEnabled(false);
            if (evt.getNewValue() == null) {
                this.setDelimiter('\u0000');
            } else {
                this.setDelimiter(((Character)evt.getNewValue()).charValue());
            }
            try {
                this.reRead();
            }
            catch (IOException ex) {
                this.settings.putProperty("WizardPanel_errorMessage", ex.getMessage());
            }
        } else if (evt.getPropertyName() == "QUALIFIER") {
            if (evt.getNewValue() == null) {
                this.setQualifier('\u0000');
            } else {
                this.setQualifier(((Character)evt.getNewValue()).charValue());
            }
            this.setValid(false);
            this.getComponent().setConfigurationPanelEnabled(false);
            try {
                this.reRead();
            }
            catch (IOException ex) {
                this.settings.putProperty("WizardPanel_errorMessage", ex.getMessage());
            }
        } else if (evt.getPropertyName() == "VARIABLENAME") {
            String varname = this.getComponent().getVariableName();
            if (varname.equals("") || !varname.equals(varname.replaceAll("[ -+*/\\()=!~`@#$%^&*<>,?;:\"']", "."))) {
                this.settings.putProperty("WizardPanel_errorMessage", "invalid variable name");
                this.setValid(false);
            } else {
                this.settings.putProperty("WizardPanel_errorMessage", null);
                this.setValid(true);
            }
        }
    }

    private void reRead() throws IOException {
        this.settings.putProperty("WizardPanel_errorMessage", null);
        this.getComponent().resetRowAndColumnsMaxAndMin();
        this.getComponent().getTableModel().clearAll();
        this.csvWorker = new CSVReaderWorker(this.zippedData.getUnzippedDataStream(), this.getComponent().getTableModel());
        this.csvWorker.execute();
    }

    private char getDelimiter() {
        return this.delimiter;
    }

    private void setDelimiter(char d) {
        this.delimiter = d;
        this.getComponent().setDelimiter(this.delimiter);
    }

    private char getQualifier() {
        return this.qualifier;
    }

    private void setQualifier(char q) {
        this.qualifier = q;
        this.getComponent().setQualifer(this.qualifier);
    }

    public void validate() throws WizardValidationException {
        int showConfirmDialog;
        String varname = this.getComponent().getVariableName();
        if (varname == null || varname.trim().equals("")) {
            throw new WizardValidationException("Please set a variable name");
        }
        if (WorkspaceView.getInstance().hasVariable(varname) && (showConfirmDialog = JOptionPane.showConfirmDialog(this.getComponent(), "A variable with the name " + varname + " exsists already!\n" + "Do you want to replace it?")) != 0) {
            throw new WizardValidationException("Variable name exists");
        }
    }

    private InputStream getInput() {
        InputStream in = null;
        if (this.settings.getProperty("PROP_DATASOURCE") == "PROP_FILE_DATASOURCE") {
            this.dataFile = (File)this.settings.getProperty("PROP_FILE");
            try {
                in = new BufferedInputStream(new FileInputStream(this.dataFile));
            }
            catch (FileNotFoundException ex) {
                this.settings.putProperty("WizardPanel_errorMessage", ex.getMessage());
            }
        } else if (this.settings.getProperty("PROP_DATASOURCE") == "PROP_PASTEDATA_DATASOURCE") {
            String data = (String)this.settings.getProperty("PROP_PASTED_DATA");
            in = new ByteArrayInputStream(data.getBytes());
        } else if (this.settings.getProperty("PROP_DATASOURCE") == "PROP_URL_DATASOURCE") {
            try {
                in = ((URL)this.settings.getProperty("PROP_URL_TO_DATA")).openStream();
            }
            catch (IOException ex) {
                this.settings.putProperty("WizardPanel_errorMessage", ex.getMessage());
            }
        } else {
            this.settings.putProperty("WizardPanel_errorMessage", "A valid data source (file,pasted data or url) is not specified");
            throw new IllegalStateException("A valid data source (file,pasted data or url) is not specified");
        }
        return in;
    }

    public void startProcessing() {
        this.isStopped = false;
        this.hasColumnNames = false;
        this.hasRowNames = false;
        InputStream in = this.getInput();
        if (in == null) {
            return;
        }
        try {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        CSVDataImportWizardStep.this.getComponent().setConfigurationPanelEnabled(false);
                    }
                });
            }
            catch (Exception ex) {
                // empty catch block
            }
            StreamFeeder streamfeeder = new StreamFeeder(in, 2);
            this.zipper = new Zipper(streamfeeder.getPipedInputStream(1));
            this.csvWorker = new CSVReaderWorker(streamfeeder.getPipedInputStream(0), this.getComponent().getTableModel());
            streamfeeder.start();
            try {
                this.csvWorker.get();
            }
            catch (Exception ex) {
                this.settings.putProperty("WizardPanel_errorMessage", ex.getMessage());
            }
            this.csvWorker = null;
            this.zipper = null;
        }
        catch (IOException ex) {
            this.settings.putProperty("WizardPanel_errorMessage", ex.getMessage());
        }
    }

    public void stopProcessing() {
        this.isStopped = true;
    }

    private void outOfMemoryHandle() {
        this.isStopped = true;
        this.settings.putProperty("WizardPanel_warningMessage", "Out of available memory!");
        JOptionPane.showMessageDialog(this.getComponent(), "Out of memory!\nPlease restart R and call speedR with an increased value in Mb!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CSVReaderWorker
    extends SwingWorker<Object, String[]> {
        private InputStream in;
        private ImportTableModel tableModel;

        public CSVReaderWorker(InputStream in, ImportTableModel tableModel) {
            this.in = in;
            this.tableModel = tableModel;
        }

        @Override
        protected Object doInBackground() throws Exception {
            try {
                String[] nextLine;
                CSVReader reader = new CSVReader((Reader)new InputStreamReader(this.in), CSVDataImportWizardStep.this.getDelimiter(), CSVDataImportWizardStep.this.getQualifier(), '\u0000');
                ImportTableModelHelper modelhelper = new ImportTableModelHelper();
                int line = 0;
                while (!CSVDataImportWizardStep.this.isStopped && (nextLine = reader.readNext()) != null) {
                    this.publish((V[])new String[][]{nextLine});
                    modelhelper.saveRowDataSet(line, nextLine);
                    ++line;
                }
                modelhelper.close();
                CSVDataImportWizardStep.this.getComponent().setImportTableModelHelper(modelhelper);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Unexpected end of the swingworker", ex);
                CSVDataImportWizardStep.this.settings.putProperty("WizardPanel_errorMessage", ex.getMessage());
            }
            catch (OutOfMemoryError err) {
                CSVDataImportWizardStep.this.outOfMemoryHandle();
            }
            return null;
        }

        @Override
        protected void process(List<String[]> chunks) {
            try {
                this.tableModel.addRows(chunks);
            }
            catch (OutOfMemoryError err) {
                CSVDataImportWizardStep.this.outOfMemoryHandle();
            }
        }

        @Override
        protected void done() {
            CSVDataImportWizardStep.this.setValid(true);
            this.tableModel.setHasColumnNames(CSVDataImportWizardStep.this.hasColumnNames);
            this.tableModel.setHasRowNames(CSVDataImportWizardStep.this.hasRowNames);
            this.tableModel.convertColumnsToNumericIfPossible();
            CSVDataImportWizardStep.this.getComponent().setConfigurationPanelEnabled(true);
            logger.log(Level.INFO, "CSVReaderWorker(SwingWorker) is done");
        }
    }

    private class Zipper
    extends Thread {
        private InputStream in;

        public Zipper(InputStream in) {
            this.in = in;
        }

        public void run() {
            try {
                int read;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ZipOutputStream out = new ZipOutputStream(bout);
                ZipEntry entry = new ZipEntry("entry");
                out.putNextEntry(entry);
                byte[] buf = new byte[8192];
                while (!CSVDataImportWizardStep.this.isStopped && (read = this.in.read(buf)) != -1) {
                    if (CSVDataImportWizardStep.this.isStopped) {
                        return;
                    }
                    out.write(buf, 0, read);
                }
                out.flush();
                out.close();
                CSVDataImportWizardStep.this.setZippedData(new OnMemoryZipEntry(entry, bout.toByteArray()));
                logger.log(Level.INFO, "zipped size: {0}", CSVDataImportWizardStep.this.zippedData.getCompressedSize() / 0x100000L);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    private class StreamFeeder
    extends Thread {
        private final int BUFFER = 8192;
        private ArrayList<PipedInputStream> pipedInStreams = new ArrayList();
        private ArrayList<PipedOutputStream> pipedOutStreams = new ArrayList();
        private InputStream in;

        public StreamFeeder(InputStream bis, int streamCount) throws IOException {
            this.in = bis;
            for (int i = 0; i < streamCount; ++i) {
                PipedOutputStream pos = new PipedOutputStream();
                PipedInputStream pis = new PipedInputStream(pos, 8192);
                this.pipedOutStreams.add(pos);
                this.pipedInStreams.add(pis);
            }
        }

        public PipedInputStream getPipedInputStream(int index) {
            return this.pipedInStreams.get(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int read;
                byte[] buf = new byte[16384];
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                while ((read = this.in.read(buf)) != -1) {
                    if (CSVDataImportWizardStep.this.isStopped) {
                        return;
                    }
                    byteOut.write(buf, 0, read);
                    String lines = byteOut.toString();
                    CSVReader reader = new CSVReader((Reader)new StringReader(lines));
                    if (reader.readNext() == null || reader.readNext() == null) continue;
                    this.determineCsvSettings(lines);
                    break;
                }
                CSVDataImportWizardStep.this.zipper.start();
                CSVDataImportWizardStep.this.csvWorker.execute();
                buf = byteOut.toByteArray();
                for (int i = 0; i < buf.length; ++i) {
                    for (PipedOutputStream pos : this.pipedOutStreams) {
                        pos.write(buf[i]);
                    }
                }
                while (!CSVDataImportWizardStep.this.isStopped && (read = this.in.read(buf)) != -1) {
                    for (PipedOutputStream pos : this.pipedOutStreams) {
                        if (CSVDataImportWizardStep.this.isStopped) continue;
                        pos.write(buf, 0, read);
                    }
                }
                for (PipedOutputStream pos : this.pipedOutStreams) {
                    pos.flush();
                    pos.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            finally {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void determineCsvSettings(String lines) throws IOException {
            char[] delimiters = new char[]{',', ';', '\t', ' ', '\u0000'};
            char[] qualifiers = new char[]{'\"', '\'', '\u0000'};
            int maxColCount = 0;
            int d_index = 0;
            int q_index = 0;
            for (int i = 0; i < delimiters.length; ++i) {
                int colCount;
                String[] nextLine;
                StringReader stringreader = new StringReader(lines);
                char d = delimiters[i];
                CSVReader csv = new CSVReader((Reader)stringreader, d, '\u0000');
                String[] header = csv.readNext();
                if (header == null || (nextLine = csv.readNext()) == null || (colCount = Math.max(header.length, nextLine.length)) <= maxColCount) continue;
                maxColCount = colCount;
                d_index = i;
                for (String h : header) {
                    if (h == null || h.equals("")) continue;
                    if (h.startsWith("\"") && h.endsWith("\"")) {
                        q_index = 0;
                        break;
                    }
                    if (h.startsWith("'") && h.endsWith("'")) {
                        q_index = 1;
                        break;
                    }
                    q_index = 2;
                }
                this.setHeaderAndRowNames(header, nextLine);
            }
            CSVDataImportWizardStep.this.setDelimiter(delimiters[d_index]);
            CSVDataImportWizardStep.this.setQualifier(qualifiers[q_index]);
        }

        private void setHeaderAndRowNames(String[] colnamesrow, String[] nextrow) {
            if (colnamesrow.length + 1 == nextrow.length || colnamesrow.length == nextrow.length && (colnamesrow[0].equals("\"\"") || colnamesrow[0].equals("") || colnamesrow[0] == null)) {
                CSVDataImportWizardStep.this.hasColumnNames = true;
                CSVDataImportWizardStep.this.hasRowNames = true;
            } else if (((String)CSVDataImportWizardStep.this.settings.getProperty("PROP_EXTENSION")).equals("csv")) {
                CSVDataImportWizardStep.this.hasColumnNames = true;
            }
        }
    }
}

