# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

eigval_sym <- function(M) {
    .Call('_spectralGraphTopology_eigval_sym', PACKAGE = 'spectralGraphTopology', M)
}

eigvec_sym <- function(M) {
    .Call('_spectralGraphTopology_eigvec_sym', PACKAGE = 'spectralGraphTopology', M)
}

inv_sympd <- function(M) {
    .Call('_spectralGraphTopology_inv_sympd', PACKAGE = 'spectralGraphTopology', M)
}

pinv <- function(M) {
    .Call('_spectralGraphTopology_pinv', PACKAGE = 'spectralGraphTopology', M)
}

#' Computes the Laplacian linear operator which maps a vector of weights into
#' a valid Laplacian matrix.
#'
#' @param w weight vector of the graph
#' @return Lw the Laplacian matrix
#'
#' @examples
#' library(spectralGraphTopology)
#' Lw <- L(c(1, 0, 1))
#' Lw
#' @export
L <- function(w) {
    .Call('_spectralGraphTopology_L', PACKAGE = 'spectralGraphTopology', w)
}

#' Computes the Adjacency linear operator which maps a vector of weights into
#' a valid Adjacency matrix.
#'
#' @param w weight vector of the graph
#' @return Aw the Adjacency matrix
#'
#' @examples
#' library(spectralGraphTopology)
#' Aw <- A(c(1, 0, 1))
#' Aw
#' @export
A <- function(w) {
    .Call('_spectralGraphTopology_A', PACKAGE = 'spectralGraphTopology', w)
}

Mmat <- function(n) {
    .Call('_spectralGraphTopology_Mmat', PACKAGE = 'spectralGraphTopology', n)
}

Pmat <- function(n) {
    .Call('_spectralGraphTopology_Pmat', PACKAGE = 'spectralGraphTopology', n)
}

vecLmat <- function(n) {
    .Call('_spectralGraphTopology_vecLmat', PACKAGE = 'spectralGraphTopology', n)
}

vec <- function(M) {
    .Call('_spectralGraphTopology_vec', PACKAGE = 'spectralGraphTopology', M)
}

#' Computes the Lstar operator.
#'
#' @param M matrix
#' @return w vector
#'
#' @export
Lstar <- function(M) {
    .Call('_spectralGraphTopology_Lstar', PACKAGE = 'spectralGraphTopology', M)
}

#' Computes the Astar operator.
#'
#' @param M matrix
#' @return w vector
#'
#' @export
Astar <- function(M) {
    .Call('_spectralGraphTopology_Astar', PACKAGE = 'spectralGraphTopology', M)
}

Linv <- function(M) {
    .Call('_spectralGraphTopology_Linv', PACKAGE = 'spectralGraphTopology', M)
}

Ainv <- function(M) {
    .Call('_spectralGraphTopology_Ainv', PACKAGE = 'spectralGraphTopology', M)
}

#' Computes the degree operator from the vector of edge weights.
#'
#' @param w vector
#' @return Dw vector
#' @export
D <- function(w) {
    .Call('_spectralGraphTopology_D', PACKAGE = 'spectralGraphTopology', w)
}

#' Computes the Dstar operator, i.e., the adjoint of the D operator.
#'
#' @param w vector
#' @return Dstar(w) vector
#'
#' @export
Dstar <- function(w) {
    .Call('_spectralGraphTopology_Dstar', PACKAGE = 'spectralGraphTopology', w)
}

Dmat <- function(n) {
    .Call('_spectralGraphTopology_Dmat', PACKAGE = 'spectralGraphTopology', n)
}

blockDiagCpp <- function(matrices) {
    .Call('_spectralGraphTopology_blockDiagCpp', PACKAGE = 'spectralGraphTopology', matrices)
}

metrics <- function(Wtrue, West, eps) {
    .Call('_spectralGraphTopology_metrics', PACKAGE = 'spectralGraphTopology', Wtrue, West, eps)
}

pairwise_matrix_rownorm2 <- function(M) {
    .Call('_spectralGraphTopology_pairwise_matrix_rownorm2', PACKAGE = 'spectralGraphTopology', M)
}

upper_view_vec <- function(M) {
    .Call('_spectralGraphTopology_upper_view_vec', PACKAGE = 'spectralGraphTopology', M)
}

