% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R, R/alignmentFunctions.R
\name{wavelengthAlign}
\alias{wavelengthAlign}
\alias{wavelengthAlign,SpectraInTime,SpectraInTime-method}
\alias{wavelengthAlign,SpectraInTime,list-method}
\title{Wavelength align spectral data}
\usage{
wavelengthAlign(ref, toAlign)

\S4method{wavelengthAlign}{SpectraInTime,SpectraInTime}(ref, toAlign)

\S4method{wavelengthAlign}{SpectraInTime,list}(ref, toAlign)
}
\arguments{
\item{ref}{\code{\link{SpectraInTime-class}} object with the reference wavelength vector}

\item{toAlign}{\code{\link{SpectraInTime-class}} object(s) to be aligned. This can either be a single SpectraInTime object
or a list of SpectraInTime objects. In case of a list, all objects in the list should have the same wavelength axis.}
}
\value{
List of aligned SpectraInTime objects, including the reference object.

one or a list of \code{\link{SpectraInTime-class}}
}
\description{
Align SpectraInTime objects with differing wavelength axes to a common wavelength axis 
using cubic spline interpolation.
}
\examples{

  spectra             <-  getSpectraInTimeExample()
  listOfSpectra       <-  getListOfSpectraExample()
  
# Dummy alignment of spectrum with itself:
  ex1                 <-  wavelengthAlign( ref = spectra , toAlign = spectra )
# Alignment of list of spectra with a reference spectrum:
  ex2                 <-  wavelengthAlign( ref = spectra , toAlign = listOfSpectra )
}
