% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectSpectraInTime.R,
%   R/spectralVisualization.R
\docType{class}
\name{SpectraInTime-class}
\alias{SpectraInTime-class}
\alias{SpectraInTime}
\alias{spectraInTime}
\alias{spectraintime}
\alias{dim,SpectraInTime-method}
\alias{extractSummarySpecs}
\alias{summary,SpectraInTime-method}
\alias{show,SummaryByWavelengths-method}
\alias{as.data.frame,SpectraInTime-method}
\alias{plot,SpectraInTime,missing-method}
\alias{plot}
\alias{plot.list}
\title{SpectraInTime-class (time resolved spectra ) wavelength-time data for 1 experiment}
\usage{
\S4method{dim}{SpectraInTime}(x)

extractSummarySpecs(object, summaryFunctions = getDefaultSumFunc())

\S4method{summary}{SpectraInTime}(object,
  summaryFunctions = getDefaultSumFunc())

\S4method{show}{SummaryByWavelengths}(object)

\S4method{as.data.frame}{SpectraInTime}(x, timePointsAlt = FALSE,
  timeUnit = "seconds")

\S4method{plot}{SpectraInTime,missing}(x, y, type = "3D",
  timeUnit = "hours", timePointsAlt = FALSE, colors = "D")

\method{plot}{list}(x, ...)
}
\arguments{
\item{x}{the object to be plotted}

\item{object}{}

\item{summaryFunctions}{a character vector of summary functions}

\item{timePointsAlt}{see \code{\link{getTimePoints}}}

\item{timeUnit}{see \code{\link{getTimePoints}}}

\item{y}{not used, for consitency with plot method}

\item{type}{character choice of plot type between:
* \code{3D} surface plot (default)
* \code{wavelenth} wavelength in legend, time on the axis
* \code{time} time in legend, wavelength on the axis}

\item{colors}{colorblind friendly palettes are used from the de \code{\link[viridis]{viridis_pal}} choice between code{"A"} (magna),
code{"B"} (inferno),  \code{"C"} (plasma) and \code{"D"} the default viridis color palette}

\item{...}{additional argument, for plotting a list of spectra one can use:
\itemize{
 \item \code{times} numeric vector of time points to plot
 \item \code{timeUnit} time unit for \code{times} default to "seconds"
 \item \code{timePointsAlt} logical value indicating whether alternative time axis should be used, defaults to \code{FALSE}
}}

\item{object}{\code{SpectraInTime-class}}

\item{summaryFunctions}{character vector of summary functions}
}
\value{
data.frame with first column wavelengths followed

a \code{data.frame} containing spectral information in long format
}
\description{
SpectraInTime-class (time resolved spectra ) wavelength-time data for 1 experiment

extract summary specs from \code{\link{SpectraInTime-class}} by wavelengths over time

convert to data.frame (used in visualization)

Plotting methods for 'spectralAnalysis'
}
\section{Slots}{

\describe{
\item{\code{spectra}}{matrix of spectral measurement with as rows timePoints and columns wavelengths}

\item{\code{experimentName}}{character vector with name of the experiment}

\item{\code{wavelengths}}{numeric vector of wavelengths}

\item{\code{timePoints}}{of measurement in seconds}

\item{\code{timePointsAlt}}{numeric vector of shifted time points in order to time align multiple spectral measurements in plots, by default equal to timePoints}

\item{\code{extraInfo}}{list additional information such as probe type}

\item{\code{startTime}}{start date and time POSIXct format}

\item{\code{units}}{list with information on measurement units}

\item{\code{preprocessing}}{list of preprocessing steps in taken in order}
}}

\examples{
  spectralExample   <-  getSpectraInTimeExample()
  mimMaxSpec        <-  spectralAnalysis:::extractSummarySpecs( spectralExample ,
 c( "min" , "max" ) )

 spectralExample  <-  getSpectraInTimeExample() 
 summarySpectra   <-  summary( spectralExample )
 str( summarySpectra )
 summarySpectra

## convert to data.frame
spectra                 <-  getSpectraInTimeExample()
spectraFlat             <-  as.data.frame( spectra )


### visualization 
  \dontrun{
  data = getSpectraInTimeExample()
  plot( x =  data , type = "3D" , timeUnit = "hours" , timePointsAlt = FALSE )
  plot( x =  data[  , r(500, 350) ] , type = "3D" ,
      timeUnit = "hours" , timePointsAlt = TRUE , colors = "B"  )
  plot( x =  data[ e( 1 , 2 , 3) , , timeUnit = "hours" ] ,
      type = "time" , timeUnit = "hours" , timePointsAlt = FALSE ) 
  plot( x =  data[ , e( seq( 200 , 400 , 50 ) ) ] , 
     type = "wavelength" , timeUnit = "minutes" , timePointsAlt = TRUE , colors = "A" )
}

  
 ## plotting a list of spectra
    
 listOfSpectra     <-  getListOfSpectraExample()
 plot( listOfSpectra , times = 1 , timeUnit = "hours" )
 plot( listOfSpectra , times = 1 , timeUnit = "hours" , timePointsAlt = TRUE  )
 plot( listOfSpectra , times = 1:3 , timeUnit = "hours" , colors = "B" ) 
}
\author{
Adriaan Blommaert
}
\keyword{internal}
