% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetHighResolutionImage.R
\name{GetHighResolutionImage}
\alias{GetHighResolutionImage}
\title{Get image limited to an area of interest}
\source{
\url{https://api.spectator.earth/#high-resolution-image}
}
\usage{
GetHighResolutionImage(
  aoi,
  id,
  bands,
  width,
  height,
  file = "image.jpg",
  api_key = Sys.getenv("spectator_earth_api_key")
)
}
\arguments{
\item{aoi}{'\code{sf}' (or '\code{Spatial*}') object defining the area of interest.
Can be of any geometry as only the bounding box is used.}

\item{id}{integer, \code{id} of the image from the \code{\link[spectator]{SearchImages}} result}

\item{bands}{integer vector of length 1 or 3 indicating the spectral bands to use for creating the image
(typically the bands corresponding to Red, Green and Blue)}

\item{width}{integer indicating the width of the image (in pixels)}

\item{height}{integer indicating the height of the image (in pixels)}

\item{file}{character indicating the name of the image file to create. Default: 'image.jpg'}

\item{api_key}{character containing your API key. Default: \code{Sys.getenv("spectator_earth_api_key")}}
}
\value{
The name of the image file is returned invisibly.
}
\description{
Provides you with a high resolution image for the area within the acquisition boundaries,
if you're not interested in downloading the whole image.
}
\details{
As a side effect, the image file is written to the provided path.
}
\examples{
if(interactive()){
 library(sf)
 my_key <- Sys.getenv("spectator_earth_api_key")
 # get the New York City Central Park shape as area of interest
 dsn <- system.file("extdata", "centralpark.geojson", package = "spectator")
 boundary <- sf::read_sf(dsn, as_tibble = FALSE)
 # search for May 2021 Sentinel 2 images 
 catalog <- SearchImages(aoi = boundary, satellites = "S2", 
     date_from = "2021-05-01", date_to = "2021-05-30", 
     footprint = FALSE, api_key = my_key)
 # get the id of the image with minimal cloud coverage
 best_id <- catalog[order(catalog$cloud_cover_percentage), ][1, "id"]
 # get the high resolution image of the Central Park
 img <- GetHighResolutionImage(aoi = boundary, id = best_id, bands = c(4, 3, 2), 
     width = 1024, height = 1024,
     file = tempfile(pattern = "img", fileext = ".jpg"), 
     api_key = my_key)
 }
}
\seealso{
\code{\link[spectator]{SearchImages}}
}
