% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HaltonFrames.R
\name{HaltonFrame}
\alias{HaltonFrame}
\title{Create a Halton Frame.}
\usage{
HaltonFrame(
  N = 1,
  J = base::c(3, 2),
  bases = base::c(2, 3),
  boundingbox = NULL,
  shapefile = NULL,
  panels = NULL,
  panel_overlap = NULL,
  seeds = NULL,
  stratum = NULL,
  verbose = FALSE
)
}
\arguments{
\item{N}{The number of points in the frame to generate.}

\item{J}{The number of grid cells. A list of 2 values. The default value is c(3, 2).}

\item{bases}{Co-prime base for the Halton Sequence. The default value is c(2, 3).}

\item{boundingbox}{Bounding box around the study area. If a bounding box is not supplied
then spbal will generate a bounding box for the shapefile.}

\item{shapefile}{A sf object. If the shapefile parameter is NULL then function
HaltonFrameBase is called directly.}

\item{panels}{A list of integers that define the size of each panel in a
non-overlapping panels design. The length of the list determines the number of
panels required. The sum of the integers in the panels parameter will determine
the total number of samples selected, n. The default value for panels is NULL,
this indicates that a non-overlapping panel design is not wanted.}

\item{panel_overlap}{A list of integers that define the overlap into the previous
panel. Is only used when the panels parameter is not NULL. The default value for
panel_overlap is NULL. The length of panel_overlap must be equal to the length
of panels. The first value is always forced to zero as the first panel never
overlaps any region.}

\item{seeds}{A vector of 2 seeds, u1 and u2. If not specified, the default is NULL.}

\item{stratum}{Name of column in shapefile that makes up the strata.}

\item{verbose}{Boolean if you want to see any output printed to screen. Helpful if taking a
long time. Default is FALSE i.e. no informational messages are displayed.}
}
\value{
Returns a list containing five variables:

\itemize{
\item \code{J} The number of grid cells. A list of 2 values that were used to generate this
Halton grid and frame.
\item \code{hg.pts.shp} Halton grid over the bounding box and study area.
\item \code{hf.pts.shp} Halton frame, the sample points within the study area.
\item \code{bb} The bounding box.
\item \code{seeds} The u1 and u2 seeds used to generate the sample.
}

The sample points in \code{hf.pts.shp} are returned in the form of a simple feature
collection of POINT objects. As well as having the features from the original \code{shapefile},
the following new attributes have been added:

\itemize{
\item \code{spbalSeqID}: A unique identifier for every sample point.
\item \code{ID}: A unique identifier, the Halton frame point order.
}
}
\description{
Halton frames discretize an areal resource into a spatially ordered grid,
where samples of consecutive frame points are spatially balanced. To generate Halton Frames,
spbal requires a study region \code{shapefile} and the region’s \code{bounding box}.
}
\examples{
# we discretize the Gates study region into a coarse grid using
# B = 2^{J_1} * 3^{J_2}= (2^3) * (3^2) (9 by 8 grid) ------------------------

# Use the North Carolina shapefile supplied in the sf R package.
shp_file <- sf::st_read(system.file("shape/nc.shp", package="sf"))
shp_gates <- shp_file[shp_file$NAME == "Gates",]

# Vertically aligned master sample bounding box.
bb <- spbal::BoundingBox(shapefile = shp_gates)

set.seed(511)
result6 <- spbal::HaltonFrame(shapefile = shp_gates,
                              J = c(3, 2),
                              boundingbox = bb)
# get the frame points.
Frame <- result6$hf.pts.shp
Frame
# get the grid points.
Grid <- result6$hg.pts.shp
Grid

}
\author{
Phil Davies.
}
