\name{vcov.mppm}
\alias{vcov.mppm}
\title{Calculate Variance-Covariance Matrix for Fitted Multiple Point
  Process Model}
\description{
  Given a fitted multiple point process model, calculate the
  variance-covariance matrix of the parameter estimates.
}
\usage{
   \method{vcov}{mppm}(object, ..., what="vcov", err="fatal")
}
\arguments{
  \item{object}{
    A multiple point process model (object of class \code{"mppm"}).
  }
  \item{\dots}{
    Arguments recognised by \code{\link{vcov.ppm}}.
  }
  \item{what}{
    Character string indicating which quantity should be calculated.
    Options include \code{"vcov"} for the variance-covariance matrix,
    \code{"corr"} for the correlation matrix, and \code{"fisher"}
    for the Fisher information matrix.
  }
  \item{err}{
    Character string indicating what action to take if an error occurs.
    Either \code{"fatal"}, \code{"warn"} or \code{"null"}.
  }
}
\details{
  This is a method for the generic function \code{\link{vcov}}.
  
  The argument \code{object} should be a fitted multiple point process
  model (object of class \code{"mppm"}) generated by \code{\link{mppm}}.
  
  The variance-covariance matrix of the parameter estimates
  is computed using asymptotic theory for maximum likelihood
  (for Poisson processes) or estimating equations (for other Gibbs models).
  
  If \code{what="vcov"} (the default), the variance-covariance matrix
  is returned. 
  If \code{what="corr"}, the variance-covariance matrix is normalised
  to yield a correlation matrix, and this is returned.
  If \code{what="fisher"}, the Fisher information matrix is returned instead.

  In all three cases, the rows and columns of the matrix correspond
  to the parameters (coefficients) in the same order as in
  \code{coef{model}}.

  If errors or numerical problems occur, the
  argument \code{err} determines what will happen. If
  \code{err="fatal"} an error will occur. If \code{err="warn"}
  a warning will be issued and \code{NA} will be returned.
  If \code{err="null"}, no warning is issued, but \code{NULL} is returned.
}
\value{
  A numeric matrix (or \code{NA} or \code{NULL}).
}
\section{Error messages}{
  An error message that reports
  \emph{system is computationally singular} indicates that the
  determinant of the Fisher information matrix of one of the models
  was either too large or too small for reliable numerical calculation.
  See \code{\link{vcov.ppm}} for suggestions on how to handle this.
}
\seealso{
  \code{\link{vcov}}, \code{\link{vcov.ppm}},
  \code{\link{mppm}}
}
\examples{
   fit <- mppm(Wat ~x, data=hyperframe(Wat=waterstriders))
   vcov(fit)
}
\references{
  Baddeley, A., Rubak, E. and Turner, R. (2015)
  \emph{Spatial Point Patterns: Methodology and Applications with R}.
  London: Chapman and Hall/CRC Press. 
}
\author{
  Adrian Baddeley, Ida-Maria Sintorn and Leanne Bischoff.
  Implemented by 
  Adrian Baddeley \email{Adrian.Baddeley@curtin.edu.au},
 Rolf Turner \email{r.turner@auckland.ac.nz}
 and Ege Rubak \email{rubak@math.aau.dk}.
}
\keyword{spatial}
\keyword{methods}
\keyword{models}
