% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{update_focal}
\alias{update_focal}
\title{Update current focal for the next iteration}
\usage{
update_focal(old_focal, new_rasterized, extent, mw)
}
\arguments{
\item{old_focal}{Focal obtained from \code{terra::focal()} for the current
iteration.}

\item{new_rasterized}{Output obtained from \code{update_rasterize()}
for the next iteration.}

\item{extent}{Extent of the cells corresponding to the coordinates with the
highest concentration for the current iteration. Extent is output from
\code{terra::ext()}.}

\item{mw}{Moving window obtained from \code{create_mw()}.}
}
\description{
Update current focal for the next iteration.
}
\details{
Spatial extent refers to the geographic area covered by a spatial
dataset. It defines the boundaries in terms of its geographic coordinates
(north, east, south, west).

An focal is updated by the following steps:
\enumerate{
 \item The extent of the cells corresponding to
 the coordinates with the highest concentration (xmin, xmax, ymin, ymax)
 is determined.
 \item A buffer of size two times the radius plus the
 cell size around this extent. All cells within this new extent will impact
 the focal values.
 \item Subset (crop) the rasterized data to include only the cells
 within this new extent. Perform focal calculations only for these new
 cells.
 \item As the focal values of the cells near the borders may be
 inflated, crop the result again to include only the cells within a radius
 of the original extent.
 \item Merge this updated focal with the previous focal object.
}
}
\author{
Martin Haringa
}
\keyword{internal}
