% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erase.points.R
\name{erase.point}
\alias{erase.point}
\title{Erase points}
\usage{
erase.point(y, x, inside = TRUE)
}
\arguments{
\item{y}{A SpatialPoints or SpatialPointsDataFrame}

\item{x}{A SpatialPolygons or SpatialPolygonsDataFrame}

\item{inside}{(TRUE/FALSE) Remove points inside polygon, else outside polygon}
}
\value{
A SpatialPoints or SpatialPointsDataFrame
}
\description{
Removes points intersecting a polygon feature class
}
\note{
Provides the same functionality as the ESRI ArcGIS Erase Point tool
}
\examples{
require(sp)
data(meuse)
coordinates(meuse) = ~x+y
poly <- SpatialPolygonsDataFrame(SpatialPolygons(list(Polygons(list(
            Polygon(cbind(c(180042, 180545, 180553, 180314, 179955,
            179142, 179437, 179524, 179979, 180042), c(332373, 332026,
			   331426, 330889, 330683, 331133, 331623, 332152, 332357,
            332373)))),'1'))), data.frame(row.names=c('1'), PIDS=1))

meuse.erase <- erase.point(meuse, poly)

par(mfrow=c(1,2))
  plot(poly,)
    points(meuse, pch=20)
  plot(poly)
    points(meuse.erase, pch=20)

}
\author{
Jeffrey S. Evans    <jeffrey_evans<at>tnc.org>
}
