% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_data.R
\name{stream_read_csv}
\alias{stream_read_csv}
\alias{stream_read_text}
\alias{stream_read_json}
\alias{stream_read_parquet}
\alias{stream_read_orc}
\alias{stream_read_kafka}
\alias{stream_read_socket}
\alias{stream_read_delta}
\title{Read files created by the stream}
\usage{
stream_read_csv(
  sc,
  path,
  name = NULL,
  header = TRUE,
  columns = NULL,
  delimiter = ",",
  quote = "\\"",
  escape = "\\\\",
  charset = "UTF-8",
  null_value = NULL,
  options = list(),
  ...
)

stream_read_text(sc, path, name = NULL, options = list(), ...)

stream_read_json(sc, path, name = NULL, columns = NULL, options = list(), ...)

stream_read_parquet(
  sc,
  path,
  name = NULL,
  columns = NULL,
  options = list(),
  ...
)

stream_read_orc(sc, path, name = NULL, columns = NULL, options = list(), ...)

stream_read_kafka(sc, name = NULL, options = list(), ...)

stream_read_socket(sc, name = NULL, columns = NULL, options = list(), ...)

stream_read_delta(sc, path, name = NULL, options = list(), ...)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{name}{The name to assign to the newly generated stream.}

\item{header}{Boolean; should the first row of data be used as a header?
Defaults to \code{TRUE}.}

\item{columns}{A vector of column names or a named vector of column types.
If specified, the elements can be \code{"binary"} for \code{BinaryType},
\code{"boolean"} for \code{BooleanType}, \code{"byte"} for \code{ByteType},
\code{"integer"} for \code{IntegerType}, \code{"integer64"} for \code{LongType},
\code{"double"} for \code{DoubleType}, \code{"character"} for \code{StringType},
\code{"timestamp"} for \code{TimestampType} and \code{"date"} for \code{DateType}.}

\item{delimiter}{The character used to delimit each column. Defaults to \samp{','}.}

\item{quote}{The character used as a quote. Defaults to \samp{'"'}.}

\item{escape}{The character used to escape other characters. Defaults to \samp{'\'}.}

\item{charset}{The character set. Defaults to \samp{"UTF-8"}.}

\item{null_value}{The character to use for null, or missing, values. Defaults to \code{NULL}.}

\item{options}{A list of strings with additional options.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Read files created by the stream
}
\examples{
\dontrun{

sc <- spark_connect(master = "local")

dir.create("csv-in")
write.csv(iris, "csv-in/data.csv", row.names = FALSE)

csv_path <- file.path("file://", getwd(), "csv-in")

stream <- stream_read_csv(sc, csv_path) \%>\% stream_write_csv("csv-out")

stream_stop(stream)
}

}
