% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_data.R
\name{stream_write_delta}
\alias{stream_write_delta}
\title{Write Delta Stream}
\usage{
stream_write_delta(
  x,
  path,
  mode = c("append", "complete", "update"),
  checkpoint = file.path("checkpoints", random_string("")),
  options = list(),
  ...
)
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{mode}{Specifies how data is written to a streaming sink. Valid values are
\code{"append"}, \code{"complete"} or \code{"update"}.}

\item{checkpoint}{The location where the system will write all the checkpoint
information to guarantee end-to-end fault-tolerance.}

\item{options}{A list of strings with additional options.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Writes a Spark dataframe stream into a Delta Lake table.
}
\details{
Please note that Delta Lake requires installing the appropriate
package by setting the \code{packages} parameter to \code{"delta"} in \code{spark_connect()}
}
\examples{
\dontrun{

library(sparklyr)
sc <- spark_connect(master = "local", version = "2.4.0", packages = "delta")

dir.create("text-in")
writeLines("A text entry", "text-in/text.txt")

text_path <- file.path("file://", getwd(), "text-in")

stream <- stream_read_text(sc, text_path) \%>\% stream_write_delta(path = "delta-test")

stream_stop(stream)
}

}
\seealso{
Other Spark stream serialization: 
\code{\link{stream_read_csv}()},
\code{\link{stream_read_delta}()},
\code{\link{stream_read_json}()},
\code{\link{stream_read_kafka}()},
\code{\link{stream_read_orc}()},
\code{\link{stream_read_parquet}()},
\code{\link{stream_read_socket}()},
\code{\link{stream_read_text}()},
\code{\link{stream_write_console}()},
\code{\link{stream_write_csv}()},
\code{\link{stream_write_json}()},
\code{\link{stream_write_kafka}()},
\code{\link{stream_write_memory}()},
\code{\link{stream_write_orc}()},
\code{\link{stream_write_parquet}()},
\code{\link{stream_write_text}()}
}
\concept{Spark stream serialization}
