% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection_spark.R, R/spark_submit.R
\name{spark-connections}
\alias{spark-connections}
\alias{spark_connect}
\alias{spark_connection_is_open}
\alias{spark_disconnect}
\alias{spark_disconnect_all}
\alias{spark_submit}
\title{Manage Spark Connections}
\usage{
spark_connect(master, spark_home = Sys.getenv("SPARK_HOME"),
  method = c("shell", "livy", "databricks", "test", "qubole"),
  app_name = "sparklyr", version = NULL, config = spark_config(),
  extensions = sparklyr::registered_extensions(), ...)

spark_connection_is_open(sc)

spark_disconnect(sc, ...)

spark_disconnect_all()

spark_submit(master, file, spark_home = Sys.getenv("SPARK_HOME"),
  app_name = "sparklyr", version = NULL, config = spark_config(),
  extensions = sparklyr::registered_extensions(), ...)
}
\arguments{
\item{master}{Spark cluster url to connect to. Use \code{"local"} to
connect to a local instance of Spark installed via
\code{\link{spark_install}}.}

\item{spark_home}{The path to a Spark installation. Defaults to the path
provided by the \code{SPARK_HOME} environment variable. If
\code{SPARK_HOME} is defined, it will always be used unless the
\code{version} parameter is specified to force the use of a locally
installed version.}

\item{method}{The method used to connect to Spark. Default connection method
is \code{"shell"} to connect using spark-submit, use \code{"livy"} to
perform remote connections using HTTP, or \code{"databricks"} when using a
Databricks clusters.}

\item{app_name}{The application name to be used while running in the Spark
cluster.}

\item{version}{The version of Spark to use. Required for \code{"local"} Spark
connections, optional otherwise.}

\item{config}{Custom configuration for the generated Spark connection. See
\code{\link{spark_config}} for details.}

\item{extensions}{Extension packages to enable for this connection. By
default, all packages enabled through the use of
\code{\link[=register_extension]{sparklyr::register_extension}} will be passed here.}

\item{...}{Optional arguments; currently unused.}

\item{sc}{A \code{spark_connection}.}

\item{file}{Path to R source file to submit for batch execution.}
}
\description{
These routines allow you to manage your connections to Spark.
}
\details{
When using \code{method = "livy"}, it is recommended to specify \code{version}
parameter to improve performance by using precompiled code rather than uploading
sources. By default, jars are downloaded from GitHub but the path to the correct
\code{sparklyr} JAR can also be specified through the \code{livy.jars} setting.
}
\examples{

sc <- spark_connect(master = "spark://HOST:PORT")
connection_is_open(sc)

spark_disconnect(sc)

}
