% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_transformation_methods.R
\name{ml-transform-methods}
\alias{ml-transform-methods}
\alias{is_ml_transformer}
\alias{is_ml_estimator}
\alias{ml_fit}
\alias{ml_transform}
\alias{ml_fit_and_transform}
\alias{ml_predict}
\alias{ml_predict.ml_model_classification}
\title{Spark ML -- Transform, fit, and predict methods (ml_ interface)}
\usage{
is_ml_transformer(x)

is_ml_estimator(x)

ml_fit(x, dataset, ...)

ml_transform(x, dataset, ...)

ml_fit_and_transform(x, dataset, ...)

ml_predict(x, dataset, ...)

\method{ml_predict}{ml_model_classification}(x, dataset,
  probability_prefix = "probability_", ...)
}
\arguments{
\item{x}{A \code{ml_estimator}, \code{ml_transformer}, or \code{ml_model} object.}

\item{dataset}{A \code{tbl_spark}.}

\item{...}{Optional arguments; currently unused.}

\item{probability_prefix}{String used to prepend the class probability output columns.}
}
\value{
When \code{x} is an estimator, \code{ml_fit()} returns a transformer whereas \code{ml_fit_and_transform()} returns a transformed dataset. When \code{x} is a transformer, \code{ml_transform()} and \code{ml_predict()} return a transformed dataset. When \code{ml_predict()} is called on a \code{ml_model} object, additional columns (e.g. probabilities in case of classification models) are appended to the transformed output for the user's convenience.
}
\description{
Methods for transformation, fit, and prediction. These are mirrors of the corresponding \link{sdf-transform-methods}.
}
\details{
These methods are
}
