% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_options.R
\name{ml_options}
\alias{ml_options}
\title{Options for Spark ML Routines}
\usage{
ml_options(id.column = random_string("id"),
  response.column = random_string("response"),
  features.column = random_string("features"),
  output.column = random_string("output"), model.transform = NULL,
  only.model = FALSE, na.action = getOption("na.action", "na.omit"), ...)
}
\arguments{
\item{id.column}{The name to assign to the generated id column.}

\item{response.column}{The name to assign to the generated response column.}

\item{features.column}{The name to assign to the generated features column.}

\item{output.column}{The name to assign to the generated output column.}

\item{model.transform}{An optional \R function that accepts a Spark model
and returns a Spark model. This can be used to supply optional Spark model
fitting parameters not made available in the \code{sparklyr} APIs.}

\item{only.model}{Boolean; should the Spark model object itself be returned
without fitting the actual model? Useful for \code{\link{ml_one_vs_rest}}.}

\item{na.action}{An \R function, or the name of an \R function, indicating
how missing values should be handled.}

\item{...}{Optional arguments, reserved for future expansion.}
}
\description{
Provide this object to the various Spark ML methods, to control certain
facets of the model outputs produced.
}
