/*
 * Decompiled with CFR 0.152.
 */
package SparkWorker;

import SparkWorker.Embedded$;
import SparkWorker.FileUtils$;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sparklyr.Logger;

@ScalaSignature(bytes="\u0006\u0001=2A!\u0001\u0002\u0001\u000b\t9!k]2sSB$(\"A\u0002\u0002\u0017M\u0003\u0018M]6X_J\\WM]\u0002\u0001'\t\u0001a\u0001\u0005\u0002\b\u00155\t\u0001BC\u0001\n\u0003\u0015\u00198-\u00197b\u0013\tY\u0001B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001b\u0001\u0011\t\u0011)A\u0005\u001d\u00051An\\4hKJ\u0004\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\tgB\f'o\u001b7ze&\u00111\u0003\u0005\u0002\u0007\u0019><w-\u001a:\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\t9\u0012\u0004\u0005\u0002\u0019\u00015\t!\u0001C\u0003\u000e)\u0001\u0007a\u0002C\u0003\u001c\u0001\u0011\u0005A$\u0001\tx_J\\WM]*pkJ\u001cWMR5mKR\tQ\u0004\u0005\u0002\u001fC9\u0011qaH\u0005\u0003A!\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0012$\u0005\u0019\u0019FO]5oO*\u0011\u0001\u0005\u0003\u0005\u0006K\u0001!\tAJ\u0001\u0005S:LG\u000f\u0006\u0002(UA\u0011q\u0001K\u0005\u0003S!\u0011A!\u00168ji\")1\u0006\na\u0001Y\u0005I1/Z:tS>t\u0017\n\u001a\t\u0003\u000f5J!A\f\u0005\u0003\u0007%sG\u000f")
public class Rscript {
    private final Logger logger;

    public String workerSourceFile() {
        String source = Embedded$.MODULE$.sources();
        File tempFile = new File(new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)FileUtils$.MODULE$.createTempDir()), File.separator)).append((Object)"sparkworker.R").toString());
        FileWriter outStream = new FileWriter(tempFile);
        outStream.write(source);
        outStream.flush();
        return tempFile.getAbsolutePath();
    }

    public void init(int sessionId) {
        SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
        String command = sparkConf.get("spark.r.command", "Rscript");
        String sourceFilePath = this.workerSourceFile();
        this.logger.log(new StringBuilder().append((Object)"Path to source file ").append((Object)sourceFilePath).toString());
        ProcessBuilder processBuilder = new ProcessBuilder(Arrays.asList((Object[])new String[]{command, "--vanilla", sourceFilePath, ((Object)BoxesRunTime.boxToInteger((int)sessionId)).toString()}));
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        this.logger.log("R process starting");
        Process process = processBuilder.start();
        int status = process.waitFor();
        if (status == 0) {
            this.logger.log("R process completed");
            return;
        }
        this.logger.logError("R process failed");
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sparklyr worker rscript failure, check worker logs for details."})).s((Seq)Nil$.MODULE$));
    }

    public Rscript(Logger logger) {
        this.logger = logger;
    }
}

