% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{comb_coils}
\alias{comb_coils}
\title{Combine coil data based on the first data point of a reference signal.}
\usage{
comb_coils(
  metab,
  ref = NULL,
  noise = NULL,
  scale = TRUE,
  scale_method = "sig_noise_sq",
  sum_coils = TRUE,
  noise_region = c(-0.5, -2.5),
  average_ref_dyns = TRUE,
  ref_pt_index = 1
)
}
\arguments{
\item{metab}{MRS data containing metabolite data.}

\item{ref}{MRS data containing reference data (optional).}

\item{noise}{MRS data from a noise scan (optional).}

\item{scale}{option to rescale coil elements based on the first data point
(logical).}

\item{scale_method}{one of "sig_noise_sq", "sig_noise" or "sig".}

\item{sum_coils}{sum the coil elements as a final step (logical).}

\item{noise_region}{the spectral region (in ppm) to estimate the noise.}

\item{average_ref_dyns}{take the mean of the reference scans in the dynamic
dimension before use.}

\item{ref_pt_index}{time-domain point to use for estimating phase and scaling
values.}
}
\value{
MRS data.
}
\description{
By default, elements are phased and scaled prior to summation. Where a
reference signal is not given, the mean dynamic signal will be used
instead.
}
