% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-zones.R
\name{spod_get_zones_v1}
\alias{spod_get_zones_v1}
\title{Retrieves the zones for v1 data}
\usage{
spod_get_zones_v1(
  zones = c("districts", "dist", "distr", "distritos", "municipalities", "muni",
    "municip", "municipios"),
  data_dir = spod_get_data_dir(),
  quiet = FALSE
)
}
\arguments{
\item{zones}{The zones for which to download the data. Can be \code{"districts"} (or \code{"dist"}, \code{"distr"}, or the original Spanish \code{"distritos"}) or \code{"municipalities"} (or \code{"muni"}, \code{"municip"}, or the original Spanish \code{"municipios"}).}

\item{data_dir}{The directory where the data is stored.}

\item{quiet}{A \code{logical} value indicating whether to suppress messages. Default is \code{FALSE}.}
}
\value{
An \code{sf} object (Simple Feature collection) with 2 fields:
\describe{
\item{id}{A character vector containing the unique identifier for each zone, to be matched with identifiers in the tabular data.}
\item{geometry}{A \code{MULTIPOLYGON} column containing the spatial geometry of each zone, stored as an sf object.
The geometry is projected in the ETRS89 / UTM zone 30N coordinate reference system (CRS), with XY dimensions.}
}
}
\description{
This function retrieves the zones data from the specified data directory.
It can retrieve either "distritos" or "municipios" zones data.
}
\keyword{internal}
