% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAGR.R
\name{CAGR}
\alias{CAGR}
\title{Compound Annual Growth Rate}
\usage{
CAGR(PV, FV, fractional_years, type = "geometric")
}
\arguments{
\item{PV}{the price at the beginning of the period}

\item{FV}{the price at the end of the period}

\item{fractional_years}{the length of the period in (fractional) years}

\item{type}{either "geometric" or "continuous"}
}
\value{
the compounded rate of return, annualized
}
\description{
\itemize{
    \item \bold{geometric} FV = PV * (1 + geometric) ** years
    \item \bold{continuous} FV = PV * exp(continuous * years)
 }
}
\note{
see \emph{r_continuous} and \emph{r_discrete}
}
\examples{
PV    <- 9000
FV    <- 13000
years <- 3
(geometric  <- CAGR(9000, 13000, years, type="geometric"))
(continuous <- CAGR(9000, 13000, years, type="continuous"))
9000 * (1 + geometric) ** years
9000 * exp(continuous * years)

\dontrun{
error <- CAGR(9000, 13000, years, type="error")}

}
\author{
George Fisher \email{GeorgeRFisher@gmail.com}
}

