% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R
\name{beat}
\alias{beat}
\title{Generate beat}
\usage{
beat(nSyl = 10, sylLen = 200, pauseLen = 50, pitch = c(200, 10),
  pitchAnchors = "deprecated", samplingRate = 16000, fadeOut = TRUE,
  play = FALSE)
}
\arguments{
\item{nSyl}{the number of syllables to generate}

\item{sylLen}{average duration of each syllable, ms}

\item{pauseLen}{average duration of pauses between syllables, ms}

\item{pitch}{fundamental frequency, Hz - a vector or data.frame(time = ...,
value = ...)}

\item{pitchAnchors}{same of pitch (deprecated)}

\item{samplingRate}{sampling frequency, Hz}

\item{fadeOut}{if TRUE, a linear fade-out is applied to the entire syllable}

\item{play}{if TRUE, plays the synthesized sound. In case of errors, try
setting another default player for \code{\link[tuneR]{play}}}
}
\value{
Returns a non-normalized waveform centered at zero.
}
\description{
Generates percussive sounds from clicks through drum-like beats to sliding
tones. The principle is to create a sine wave with rapid frequency modulation
and to add a fade-out. No extra harmonics or formants are added. For this
specific purpose, this is vastly faster and easier than to tinker with
\code{\link{soundgen}} settings, especially since percussive syllables tend
to be very short.
}
\examples{
playback = c(TRUE, FALSE)[2]
# a drum-like sound
s = beat(nSyl = 1, sylLen = 200,
         pitch = c(200, 100), play = playback)
# plot(s, type = 'l')

# a dry, muted drum
s = beat(nSyl = 1, sylLen = 200,
         pitch = c(200, 10), play = playback)

# sci-fi laser guns
s = beat(nSyl = 3, sylLen = 300,
         pitch = c(1000, 50), play = playback)

# machine guns
s = beat(nSyl = 10, sylLen = 10, pauseLen = 50,
         pitch = c(2300, 300), play = playback)
}
