% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_soundgen.R
\name{crossFade}
\alias{crossFade}
\title{Join two waveforms by cross-fading}
\usage{
crossFade(ampl1, ampl2, samplingRate, crossLen = 15, crossLenPoints = NULL)
}
\arguments{
\item{ampl1, ampl2}{two numeric vectors (waveforms) to be joined}

\item{samplingRate}{the sampling rate of input vectors, Hz}

\item{crossLen}{the length of overlap, in ms (doesn't need to be specified
if crossLenPoints is not NULL)}

\item{crossLenPoints}{(optional) the length of overlap, in points (defaults to
NULL)}
}
\value{
Returns a numeric vector.
}
\description{
\code{crossFade} joins two input vectors (waveforms) by cross-fading. It
truncates both input vectors, so that \code{ampl1} ends with a zero crossing
and \code{ampl2} starts with a zero crossing, both on an upward portion of
the soundwave. Then it cross-fades both vectors linearly with an overlap of
crossLen or crossLenPoints. If the input vectors are too short for the
specified length of cross-faded region, the two vectors are concatenated at
zero crossings instead of cross-fading. Soundgen uses \code{crossFade} for
gluing together epochs with different regimes of pitch effects (see the
vignette on sound generation), but it can also be useful for joining two
separately generated sounds without audible artifacts.
}
\examples{
sound1 = sin(1:100 / 9)
sound2 = sin(7:107 / 3)
plot(c(sound1, sound2), type = 'b')
# an ugly discontinuity at 100 that will make an audible click

sound = crossFade(sound1, sound2, crossLenPoints = 5)
plot(sound, type = 'b') # a nice, smooth transition
length(sound) # but note that cross-fading costs us ~60 points
#  because of trimming to zero crossings
}
