% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_pitch_postprocessing.R
\name{pathfinding_slow}
\alias{pathfinding_slow}
\title{Path through pitch candidates: slow}
\usage{
pathfinding_slow(pitchCands = pitchCands, pitchCert = pitchCert,
  certWeight = certWeight, pitchCenterGravity = pitchCenterGravity,
  annealPars = list(maxit = 5000, temp = 1000))
}
\arguments{
\item{pitchCands}{a matrix of multiple pitch candidates per fft frame. Each
column is one fft frame, each row is one candidate.}

\item{pitchCert}{a matrix of the same dimensionality as pitchCands specifying
our certainty in pitch candidates}

\item{certWeight}{(0 to 1) in pitch postprocessing, specifies how much we
prioritize the certainty of pitch candidates vs. pitch jumps / the internal
tension of the resulting pitch curve}

\item{pitchCenterGravity}{numeric vector giving the mean of all pitch
candidates per fft frame weighted by our certainty in each of these
candidates}

\item{annealPars}{a list of control parameters for postprocessing of
pitch contour with SANN algorithm of \code{\link[stats]{optim}}. This is
only relevant if \code{pathfinding = 'slow'}}
}
\description{
Internal soundgen function.
}
\details{
Optimizes the path through pitch candidates using simulated annealing with
\code{\link[stats]{optim}}. This can be really slow, depending on control
parameters.
}
\keyword{internal}
