% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sophisthse.R
\name{get_stat_hse_info_vector}
\alias{get_stat_hse_info_vector}
\title{Obtain additional information for specific time series}
\usage{
get_stat_hse_info_vector(series.name = "IP_EA_Q", n.vars = 1,
  info = c("methodology", "source", "comment"), ...)
}
\arguments{
\item{series.name}{the names of the time series}

\item{n.vars}{number of variables}

\item{info}{type of information (methodology/source/comment)}

\item{...}{further arguments passed into getURL. One may use them to work with proxy.}
}
\value{
character vector with info for each variable
}
\description{
Obtain additional information for specific time series from sophist.hse.ru
}
\details{
Internal function. Obtain additional information for specific time series
from sophist.hse.ru. Either 'methodology', 'source' or 'comment'.
}
\examples{
info <- sophisthse:::get_stat_hse_info_vector('IP_EA_Q', 1, 'methodology')
}

