% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windowing.R
\name{windowing}
\alias{windowing}
\title{Windowing Function for Wave Objects}
\usage{
windowing(
  wave,
  window.length,
  window.overlap = 0,
  bind.wave = TRUE,
  FUN,
  ...,
  cluster = NULL
)
}
\arguments{
\item{wave}{A Wave object}

\item{window.length}{The lag used to create the A-matrix}

\item{window.overlap}{A matrix used to code the Duration-Shape pairs}

\item{bind.wave}{If TRUE and FUN returns wave objects these are combined into a single object}

\item{FUN}{If TRUE plots the workings of the coding algorithm}

\item{...}{Additional parameters to FUN}

\item{cluster}{A cluster form the 'parallel' package for multicore computation}
}
\description{
Separates a Wave object into windows of a defined length and runs a function on the window section. Windows may overlap, and the function can make use of 'parallel' package for multicore processing.
}
\examples{
\dontrun{
windowing(wave, window.length=1000, window.overlap=0, bind.wave=TRUE, FUN=noChange)
}
}
\keyword{wave}
