% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dutyCycle.R
\name{dutyCycle}
\alias{dutyCycle}
\title{Calculate the duty cycle of a wave}
\usage{
dutyCycle(wave, limit = 0.1, output = "unit", normalise = TRUE)
}
\arguments{
\item{wave}{A Wave object}

\item{limit}{Threshold above which to consider the signal}

\item{output}{If "unit" the duty cycle will be in the range 0-1. For a percentage use "percent".}

\item{normalise}{If TRUE the Wave is normalised using tuneR}
}
\value{
A numerical value for the duty cycle between 0 and 1 (or 0 and 100% if percentage output).
}
\description{
Proportion of a wave with signal above the limit
}
\examples{
wave <- tuneR::sine(2000)
dc <- dutyCycle(wave)
pc <- dutyCycle(wave, output="percent")
}
