% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoBandPass.R
\name{autoBandPass}
\alias{autoBandPass}
\title{Automatic Band Pass Filter}
\usage{
autoBandPass(wave, bw = "-3dB", n.bw = 1, lowcut = 1000)
}
\arguments{
\item{wave}{A Wave object}

\item{bw}{Either -3dB or -10dB. This is calculated by \code{frequencyStats}}

\item{n.bw}{The number of bandwidths either side of the centre of the centre to keep}

\item{lowcut}{High-pass filtering is applied at this frequency before calculating the centre frequency and bandwidth}
}
\value{
A band-pass filtered Wave object
}
\description{
Creates an automatic bandpass filter based on the strongest frequency. The allowed bandwidth can be an
integer multiple of the bandwidth at either -3dB or -10dB.
}
\examples{
\dontrun{
autoBandPass(sheep)
autoBandPass(sheep, bw="-3dB", n.bw=1, lowcut=1000)
autoBandPass(sheep, bw="-10dB", n.bw=2, lowcut=0)
}
}
