% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadMatrix.R
\name{loadMatrix}
\alias{loadMatrix}
\title{Load Data and Convert to a Matrix}
\usage{
loadMatrix(input, remove_row_headings = FALSE, scaling = "no")
}
\arguments{
\item{input}{A string specifying the path to the CSV file, or an in-memory
object (data frame or matrix).}

\item{remove_row_headings}{A logical value. If `TRUE`, removes the first column of the dataset. This is useful when the first column contains non-numeric identifiers (e.g., sample names) that should be excluded from the analysis. Default is `FALSE`.}

\item{scaling}{A string specifying the scaling method. Options are:
\describe{
  \item{"no"}{No scaling is applied (default).}
  \item{"simpleFeature"}{Each column is divided by its maximum value.}
  \item{"minMax"}{Each column is scaled to range [0, 1].}
  \item{"zScore"}{Each column is Z-score standardized.}
}}
}
\value{
A matrix with the processed data.
}
\description{
Loads data from a CSV file or an in-memory object (data frame or matrix),
optionally removes row headings, and applies specified normalization methods
before converting the data to a matrix. In the original dataset, rows represent
observations (e.g., samples), columns represent variables (e.g., features),
and all cells (except for column headers and, if applicable, row headers)
must only contain numeric values.
}
\examples{
# Example 1: Load toy data from a CSV file
file_path <- system.file("extdata", "toy_data.csv", package = "somhca")

# Run the loadMatrix function with the mock data
myMatrix <- loadMatrix(file_path, TRUE, "minMax")

# Example 2: Load from a toy data frame
df <- data.frame(
  ID = paste0("Sample", 1:100), # Character column for row headings
  matrix(rnorm(900), nrow = 100, ncol = 9) # Numeric data
)

# Run the loadMatrix function with the mock data
myMatrix <- loadMatrix(df, TRUE, "zScore")

# Example 3: Load from a toy matrix
mat <- matrix(rnorm(900), nrow = 100, ncol = 9) # Numeric data

# Run the loadMatrix function with the mock data
myMatrix <- loadMatrix(mat, FALSE, "simpleFeature")
}
