% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/transforms.lib.R
\name{transformTrait}
\alias{transformTrait}
\title{Transform a trait.}
\usage{
transformTrait(x, transform, mult = 1, ...)
}
\arguments{
\item{x}{a numeric vector (of a trait).}

\item{transform}{a character vector, the name of transformation.
Possible values are returned by \code{\link{availableTransforms}} function.}

\item{mult}{A numeric, the multiplicator for the transformed value of a trait.
The default value is \code{1}.}

\item{...}{additional parameters passed to internal \code{transform_trait_*} functions.
   Possible parameters might be \code{log.base}, \code{log.intercept} (\code{"log"} transformation).}
}
\value{
A numeric vector, which contains the transformed values (of a trait).
}
\description{
Transform a trait.
}
\examples{
library(plyr)
library(ggplot2)

data(dat30)
dat <- mutate(dat30,
   inormal_trait1 = transformTrait(trait1, "inormal"))

ggplot(dat, aes(trait1)) + geom_histogram()
ggplot(dat, aes(inormal_trait1)) + geom_histogram()
}
\seealso{
\code{\link{availableTransforms}}, \code{\link{transformData}}
}

