% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchSCAN.R
\name{SCAN_sensor_metadata}
\alias{SCAN_sensor_metadata}
\alias{SCAN_site_metadata}
\alias{fetchSCAN}
\title{Get daily climate data from USDA-NRCS SCAN (Soil Climate Analysis Network) Stations}
\usage{
SCAN_sensor_metadata(site.code)

SCAN_site_metadata(site.code = NULL)

fetchSCAN(site.code, year, report = "SCAN", ...)
}
\arguments{
\item{site.code}{a vector of site codes. If \code{NULL} \code{SCAN_site_metadata()} returns metadata for all SCAN sites.}

\item{year}{a vector of years}

\item{report}{report name, single value only}

\item{...}{additional arguments (not used)}
}
\value{
a \code{data.frame} object; \code{NULL} on bad request.
}
\description{
Query soil/climate data from USDA-NRCS SCAN Stations
}
\details{
Possible above and below ground sensor types include: 'SMS' (soil moisture), 'STO' (soil temperature), 'SAL' (salinity), 'TAVG' (daily average air temperature), 'TMIN' (daily minimum air temperature), 'TMAX' (daily maximum air temperature), 'PRCP' (daily precipitation), 'PREC' (daily precipitation), 'SNWD' (snow depth), 'WTEQ' (snow water equivalent),'WDIRV' (wind direction), 'WSPDV' (wind speed), 'LRADT' (solar radiation/langley total).
\itemize{
\item More on \href{https://www.nrcs.usda.gov/wps/portal/wcc/home/dataAccessHelp/faqs/scanSensors/}{SCAN sensors}
\item More on \href{https://www.nrcs.usda.gov/wps/portal/wcc/home/dataAccessHelp/faqs/snotelSensors/}{SNOTEL sensors}
}

See the \href{https://www.nrcs.usda.gov/wps/portal/wcc/home/dataAccessHelp/faqs/}{SCAN and SNOTEL FAQ} for answers to common questions about these data.

See the \href{http://ncss-tech.github.io/AQP/soilDB/fetchSCAN-demo.html}{fetchSCAN tutorial} for additional usage and visualization examples.
}
\examples{

\donttest{
if(requireNamespace("curl") &
    curl::has_internet()) {

    # get data
    x <- fetchSCAN(site.code=c(356, 2072), year=c(2015, 2016))
    str(x)

    # get sensor metadata
    m <- SCAN_sensor_metadata(site.code=c(356, 2072))

    # get site metadata
    m <- SCAN_site_metadata(site.code=c(356, 2072))
}
}

}
\references{
https://www.nrcs.usda.gov/wps/portal/wcc/home/
}
\author{
D.E. Beaudette, A.G. Brown
}
\keyword{manip}
