% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSSL_VG_model.R
\name{KSSL_VG_model}
\alias{KSSL_VG_model}
\title{Develop a Water Retention Curve from KSSL Data}
\usage{
KSSL_VG_model(VG_params, phi_min = 10^-6, phi_max = 10^8, pts = 100)
}
\arguments{
\item{VG_params}{\code{data.frame} or \code{list} object with the parameters of the van Genuchten model, see details}

\item{phi_min}{lower limit for water potential in kPa}

\item{phi_max}{upper limit for water potential in kPa}

\item{pts}{number of points to include in estimated water retention curve}
}
\value{
A list with the following components:
\describe{
  \item{VG_curve}{estimated water retention curve: paired estimates of water potential (phi) and water content (theta)}
  \item{VG_function}{spline function for converting water potential (phi, units of kPa) to estimated volumetric water content (theta, units of percent, range: \{0, 1\})}
  \item{VG_inverse_function}{spline function for converting volumetric water content (theta, units of percent, range: \{0, 1\}) to estimated water potential (phi, units of kPa)}
}
}
\description{
Water retention curve modeling via van Genuchten model and KSSL data.
}
\details{
This function was developed to work with measured or estimated parameters of the \href{https://en.wikipedia.org/wiki/Water_retention_curve}{van Genuchten model}, as generated by the \href{https://www.ars.usda.gov/pacific-west-area/riverside-ca/agricultural-water-efficiency-and-salinity-research-unit/docs/model/rosetta-model/}{Rosetta model}. As such, \code{VG_params} should have the following format and conventions:
\describe{
  \item{theta_r}{saturated water content, values should be in the range of \{0, 1\}}
  \item{theta_s}{residual water content, values should be in the range of \{0, 1\}}
  \item{alpha}{related to the inverse of the air entry suction, function expects log10-transformed values with units of cm}
  \item{npar}{index of pore size distribution, function expects log10-transformed values with units of 1/cm}
}
}
\note{
A practical example is given in the \href{http://ncss-tech.github.io/AQP/soilDB/fetchSCAN-demo.html}{fetchSCAN tutorial}.
}
\examples{

# basic example
d <- data.frame(
  theta_r = 0.0337216, 
  theta_s = 0.4864061, 
  alpha = -1.581517, 
  npar = 0.1227247
)

vg <- KSSL_VG_model(d)

str(vg)

}
\references{
\href{https://en.wikipedia.org/wiki/Water_retention_curve}{water retention curve estimation}
}
\author{
D.E. Beaudette
}
