% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_softmax5_xml.R, R/read_softmax6_xml.R,
%   R/read_softmax_xml.R
\name{read_softmax5_xml}
\alias{read_softmax5_xml}
\alias{read_softmax6_xml}
\alias{read_softmax_xml}
\title{Read a 'SoftMax Pro' XML File}
\usage{
read_softmax5_xml(file, ...)

read_softmax6_xml(file, ...)

read_softmax_xml(file, ...)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data (either a
single string or a raw vector).}

\item{...}{Additional arguments passed to \code{\link[xml2]{read_xml}}}
}
\value{
A \code{softermax} object that contains data for each experiment and
plate specified in the given file
}
\description{
\code{read_softmax_xml} will attempt to automatically determine the
appropriate file version. \code{read_softmax5_xml} and
\code{read_softmax6_xml} will attempt to read the data as 'SoftMax Pro'
version 5 and 6 format, respectively.
}
\note{
XML files created by 'SoftMax Pro' version 6 do not differentiate among
multiple experiments, so only one experiment will be present in the results.
This can lead to problems when multiple experiments have plates with the same
name. Future versions will detect this situation and rename plates with
name collisions.
}
\examples{
\dontrun{
d <- read_softmax_xml("myfile.xml")
}

}
