% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_analysis.r
\name{supplementary.individuals}
\alias{supplementary.individuals}
\title{Add supplementary individuals to a result object}
\usage{
supplementary.individuals(object, sup.indicator, replace = FALSE)
}
\arguments{
\item{object}{is a soc.ca class object created with \link{soc.mca}}

\item{sup.indicator}{is a indicator matrix for the supplementary individuals with the same columns as the active variables in object.}

\item{replace}{if TRUE the coordinates of the active individuals are discarded. If FALSE the coordinates of the supplementary and active individuals are combined. The factor \code{object$supplementary.individuals} marks the supplementary individuals.}
}
\value{
a soc.ca class object created with \link{soc.mca}
}
\description{
Add supplementary individuals to a result object
}
\examples{
example(soc.mca)
res.pas   <- soc.mca(active, passive = "Costume")
res.sup   <- supplementary.individuals(res.pas, sup.indicator = indicator(active))
a         <- res.sup$coord.ind[res.sup$supplementary.individuals == "Supplementary",]
b         <- res.pas$coord.ind
all.equal(as.vector(a), as.vector(b))
map.ind(res.sup)
}

