% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootCI.R
\name{bootCI}
\alias{bootCI}
\title{Build Bootstrap Confidence Intervals for \eqn{\hat{p_k}}{p^_k}}
\usage{
bootCI(outBootdeg, bootstrap_mean = T, lower_bound = 0.025,
  upper_bound = 0.975)
}
\arguments{
\item{outBootdeg}{A list that is the output of \code{\link{bootdeg}}}

\item{bootstrap_mean}{A Boolean option to return the bootstrap confidence
interval for the mean.}

\item{lower_bound}{The lower quantile for the bootstrap confidence intervals.}

\item{upper_bound}{The upper quantile for the bootstrap confidence intervals.}
}
\value{
A list of two elements
 \item{p_k_CI}{This a list of length \code{length(outBootdeg$num.sam)}, one
   element per LSMI. Each element contains three sets of bootstrap confidence
   intervals for \eqn{\hat{p}_k^*} corresponding to the three estimation
   methods. See \code{\link{bootdeg}} for more on the three estimation methods.}
 \item{mean_CI}{This a list of length \code{length(outBootdeg$num.sam)}, one
   element per LSMI. Each element contains three sets of bootstrap confidence
   intervals for \eqn{\hat{\mu}} corresponding to the three estimation
   methods. See \code{\link{bootdeg}} for more on the three estimation methods.}
}
\description{
The function will build bootstrap confidence intervals for the bootstrap
estimate of  and \eqn{\mu} with a lower-bound of
\code{0.025} and an upper-bound of \code{0.975}.
}
\examples{
net <- artificial_networks[[1]]
sam.out <- Oempdegreedistrib(net = net, n.seeds = 40, n.neigh = 1, num.sam = 1)
outBootdeg <- bootdeg(sam.out = sam.out, n.boot = 50)
a <- bootCI(outBootdeg)
}
\references{
Efron, B. (1979). Bootstrap methods: another look at the
 jackknife. The annals of Statistics, 1-26.

Thompson, M. E., Ramirez Ramirez, L. L., Lyubchich, V. and
 Gel, Y. R. (2015), Using the bootstrap for statistical inference
 on random graphs. Can J Statistics. doi: 10.1002/cjs.11271
}

