% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_common_legend.R
\name{sm_common_legend}
\alias{sm_common_legend}
\title{Creating a common legend for subplots on a separate panel}
\usage{
sm_common_legend(
  x = 0.5,
  y = 0.5,
  title = FALSE,
  direction = "vertical",
  border = TRUE,
  legend_spacing = 0.5,
  border_color = "black",
  textRatio = 1
)
}
\arguments{
\item{x}{Location of the legend along the x-axis. Default is the middle origin (0.5).}

\item{y}{Location of the legend along the y-axis. Default is the middle origin (0.5).}

\item{title}{Title of the legend. Input should be string}

\item{direction}{Direction of the legend: 'horizontal' or 'vertical'.}

\item{border}{If set TRUE, border around the legend will be created.
If set FALSE, the border will be removed.}

\item{legend_spacing}{Spacing within the legend.}

\item{border_color}{Color of the legend border}

\item{textRatio}{Size of the text relative to the plot's default. It has been set to 1.2. The larger
the textRatio, the larger the texts in the legend.}
}
\value{
It prints a legend on a blank plot. It can be used to create
a common legend for subplots.
}
\description{
Creating a common legend for subplots on a separate panel
}
\examples{
library(ggplot2)
library(smplot2)
ggplot(data = mtcars, mapping = aes(x = drat, y = mpg,
fill = as.factor(cyl))) +
 geom_point(shape = 21, color = 'white', size = 3) +
 sm_common_legend(x = .5, y = 0.5 , direction='horizontal',
                  border=FALSE)

}
