% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elfunctions.R
\name{ctracelr}
\alias{ctracelr}
\title{Compute empirical likelihood on a trajectory}
\usage{
ctracelr(z, ct = NULL, mu0, mu1, N = 5, order = 4, verbose = FALSE, ...)
}
\arguments{
\item{z}{Passed to [EL1()].}

\item{ct}{Passed to [EL1()].}

\item{mu0}{Starting point of trajectory}

\item{mu1}{End point of trajectory}

\item{N}{Number of segments into which the path is split (i. e. \code{N+1} steps are used).}

\item{order}{Passed to [EL1()]. It is highly advised to avoid using \code{NA}
(no extrapolation) because the lambda search may fail with unmodified logarithm.}

\item{verbose}{Logical: report iteration progress?}

\item{...}{Passed to [EL1()].

This function does not accept the starting lambda because it is much faster (3--5 times)
to reuse the lambda from the previous iteration.}
}
\value{
A matrix with one row at each mean from mu0 to mu1 and a column for each EL return value (except EL weights).
}
\description{
Compute empirical likelihood on a trajectory
}
\examples{
# Plot 2.5 from Owen (2001)
earth <- c(
  5.5, 5.61, 4.88, 5.07, 5.26, 5.55, 5.36, 5.29, 5.58, 5.65, 5.57, 5.53, 5.62, 5.29,
  5.44, 5.34, 5.79, 5.1, 5.27, 5.39, 5.42, 5.47, 5.63, 5.34, 5.46, 5.3, 5.75, 5.68, 5.85
)
EL1(earth, mu = 5.1,  verbose = TRUE)
logELR <- ctracelr(earth, mu0 = 5.1, mu1 = 5.65, N = 55, verbose = TRUE)
hist(earth, breaks = seq(4.75, 6, 1/8))
plot(logELR[, 1], exp(logELR[, 2]), bty = "n", type = "l",
     xlab = "Earth density", ylab = "ELR")

# Two-dimensional trajectory
set.seed(1)
xy <- matrix(rexp(200), ncol = 2)
logELR2 <- ctracelr(xy, mu0 = c(0.5, 0.5), mu1 = c(1.5, 1.5), N = 100)
}
