% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l1tp.smooth.R
\name{smoothAPC}
\alias{smoothAPC}
\title{Smooths demographic data optionally taking into account period and cohort effects}
\usage{
smoothAPC(data, lambda = 1, lambdaaa = 1, lambdayy = 1, lambdaay = 1,
  lambdaYearsEffect = 5, thetaYearsEffect = 0.1 * lambda,
  lambdaCohortEffect = 5, thetaCohortEffect = 0.1 * lambda,
  cornerLength = 7, effects = TRUE, affdDiagonals = NULL,
  affdYears = NULL, control = list(nnzlmax = 1e+06, nsubmax = 2e+06, tmpmax
  = 2e+05), weights = NULL)
}
\arguments{
\item{data}{Demographic data (log mortality) presented as a matrix.
Row numbers represent ages and column numbers represet time.}

\item{lambda}{Controls "general flexibility" of the smooth surface.}

\item{lambdaaa}{Controls "flexibility" of the smooth surface in age direction (first dimension).}

\item{lambdayy}{Controls "flexibility" of the smooth surface in years direction (second dimension).}

\item{lambdaay}{Controls "flexibility" of the smooth surface in age and years directions.}

\item{lambdaYearsEffect}{Controls "flexibility" of the period effects.}

\item{thetaYearsEffect}{Reduces the likelihood of period effects.}

\item{lambdaCohortEffect}{Controls "flexibility" of the cohort effects.}

\item{thetaCohortEffect}{Reduces the likelihood of cohort effects.}

\item{cornerLength}{Sets the smallest length of a diagonal to be considered for cohort effects.}

\item{effects}{Controls if the cohort and period effects are taken into account.}

\item{affdDiagonals}{Diagonals to be used for cohort effects.}

\item{affdYears}{Years to be used for period effects.}

\item{control}{Control data passed directly to \code{\link[quantreg]{rq.fit.sfn}} function..}

\item{weights}{Define how much every observation effect the resulting smooth surface.
The parameter must have same dimentions as \code{data} parameter.
Weights can be set to reciprocal of estimated standard deviation of the data.}
}
\value{
List of three components: smooth surface, period effects, cohort effects.
}
\description{
Smooths demographic data optionally taking into account period and cohort effects
}
\examples{
\dontrun{

library(demography)
m <- log(fr.mort$rate$female[1:30, 150:160])
sm <- smoothAPC(m, lambdaaa = 0.2, lambdayy = 0.1, lambdaay = 0.4, effects = FALSE)
plot(sm, "original")
plot(sm)

}
}
\references{
\url{http://robjhyndman.com/working-papers/mortality-smoothing/}
}
\seealso{
\code{\link{autoSmoothAPC}}, \code{\link{signifAutoSmoothAPC}}.
}
\author{
Alexander Dokumentov
}
