% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simsma.R
\name{sim.sma}
\alias{sim.sma}
\title{Simulate Simple Moving Average}
\usage{
sim.sma(order = NULL, obs = 10, nsim = 1, frequency = 1,
  initial = NULL, randomizer = c("rnorm", "rt", "rlaplace", "rs"),
  iprob = 1, ...)
}
\arguments{
\item{order}{Order of the modelled series. If omitted, then a random order from 1 to 100 is selected.}

\item{obs}{Number of observations in each generated time series.}

\item{nsim}{Number of series to generate (number of simulations to do).}

\item{frequency}{Frequency of generated data. In cases of seasonal models
must be greater than 1.}

\item{initial}{Vector of initial states for the model. If \code{NULL},
values are generated.}

\item{randomizer}{Type of random number generator function used for error
term. Defaults are: \code{rnorm}, \code{rt}, \code{rlaplace} and \code{rs}.
\code{rlnorm} should be used for multiplicative models (e.g. ETS(M,N,N)).
But any function from \link[stats]{Distributions} will do the trick if the
appropriate parameters are passed. For example \code{rpois} with
\code{lambda=2} can be used as well, but might result in weird values.}

\item{iprob}{Probability of occurrence, used for intermittent data
generation. This can be a vector, implying that probability varies in time
(in TSB or Croston style).}

\item{...}{Additional parameters passed to the chosen randomizer. All the
parameters should be passed in the order they are used in chosen randomizer.
For example, passing just \code{sd=0.5} to \code{rnorm} function will lead
to the call \code{rnorm(obs, mean=0.5, sd=1)}.}
}
\value{
List of the following values is returned:
\itemize{
\item \code{model} - Name of SMA model.
\item \code{data} - Time series vector (or matrix if \code{nsim>1}) of the generated
series.
\item \code{states} - Matrix (or array if \code{nsim>1}) of states. States are in
columns, time is in rows.
\item \code{initial} - Vector (or matrix) of initial values.
\item \code{iprob} - vector of probabilities used in the simulation.
\item \code{intermittent} - type of the intermittent model used.
\item \code{residuals} - Error terms used in the simulation. Either vector or matrix,
depending on \code{nsim}.
\item \code{occurrences} - Values of occurrence variable. Once again, can be either
a vector or a matrix...
\item \code{logLik} - Log-likelihood of the constructed model.
}
}
\description{
Function generates data using SMA in a Single Source of Error state space
model as a data generating process.
}
\examples{

# Create 40 observations of quarterly data using AAA model with errors from normal distribution
sma10 <- sim.sma(order=10,frequency=4,obs=40,randomizer="rnorm",mean=0,sd=100)

}
\references{
\itemize{
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \url{http://dx.doi.org/10.1007/978-3-540-71918-2}.
}
}
\seealso{
\code{\link[smooth]{es}, \link[forecast]{ets},
\link[forecast]{forecast}, \link[stats]{ts}, \link[stats]{Distributions}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
