% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{checkX}
\alias{checkX}
\alias{checkX,Grid-method}
\alias{checkX,matrix-method}
\title{Check designs: size and colnames}
\usage{
checkX(X, XNew, ...)
}
\arguments{
\item{X}{Design or grid object.}

\item{XNew}{Matrix containing (as rows) the points where
interpolation must be done, or numeric vector with length \code{d}
where \code{d} is the space dimension provided by \code{X}.}

\item{...}{Other arguments to be passed to methods.}
}
\value{
A list with a matrix element \code{XNew} corresponding to
the wanted matrix possibly coerced and with colnames matching
those of \code{X}.
}
\description{
Check designs: size and colnames.
}
\details{
Check that the objects \code{XNew} and \code{X} are compatible
for interpolation.
}
\note{
The order of the two formal arguments has been changed in
version 0.0-4.  Former code using positional matching may lead to
unexpected results.
}
\examples{
X <- matrix(1:12, ncol = 3)
colnames(X) <- c("Temp", "Press", "Volume")
XNew <- matrix(1:3, ncol = 3)
XNewMod <- checkX(X = X, XNew = XNew)$XNew
XNewMod
}

