% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptic.sim.adj.R
\name{elliptic.sim.adj}
\alias{elliptic.sim.adj}
\title{Perform \code{elliptic.test} on simulated data}
\usage{
elliptic.sim.adj(
  nsim = 1,
  ex,
  nn,
  ty,
  logein,
  logeout,
  a,
  pen,
  min.cases = 2,
  cl = NULL
)
}
\arguments{
\item{nsim}{A positive integer indicating the number of
simulations to perform.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nn}{A list of nearest neighbors produced by
\code{\link{elliptic.nn}}.}

\item{ty}{The total number of cases in the study area.}

\item{logein}{The \code{log} of the expected number of
cases in each candidate zone.}

\item{logeout}{The \code{log} of the expected number of
cases outside of each candidate zone.}

\item{a}{The penalty for the spatial scan statistic.  The
default is 0.5.}

\item{pen}{The eccentricity penalty for each candidate
zone.}

\item{min.cases}{The minimum number of cases required for
a cluster.  The default is 2.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}
}
\value{
A vector with the maximum test statistic for each
  simulated data set.
}
\description{
\code{elliptic.sim} efficiently performs
\code{\link{elliptic.test}} on a simulated data set.  The
function is meant to be used internally by the
\code{\link{elliptic.test}} function, but is informative
for better understanding the implementation of the test.
}
\examples{
data(nydf)
data(nyw)
coords <- with(nydf, cbind(longitude, latitude))
pop <- nydf$pop
enn <- elliptic.nn(coords, pop, ubpop = 0.5)
cases <- floor(nydf$cases)
ty <- sum(cases)
ex <- ty / sum(pop) * pop
yin <- nn.cumsum(enn$nn, cases)
ein <- nn.cumsum(enn$nn, ex)
logein <- log(ein)
logeout <- log(ty - ein)
pen <- elliptic.penalty(0.5, enn$shape_all)
tsim <- elliptic.sim.adj(
  nsim = 3, ex = ex,
  nn = enn$nn, ty = ty,
  logein = logein, logeout = logeout,
  a = 0.5, pen = pen
)
}
