% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg2.R
\name{csg2}
\alias{csg2}
\alias{lcsg2}
\alias{scsg2}
\title{Construct connected subgraphs}
\usage{
csg2(cz, cnn, cw)

lcsg2(lcz, cnn, cw)

scsg2(
  nn,
  w,
  idx = seq_along(nn),
  nlevel = NULL,
  verbose = FALSE,
  logical = FALSE
)
}
\arguments{
\item{cz}{A logical vector representing the current subgraph.}

\item{cnn}{The indices of the neighbors of the current vertex.}

\item{cw}{A binary adjacency matrix for the neighbors of the current vertex.}

\item{lcz}{A list of current zones (in the form of logical vectors).}

\item{nn}{A list of the nearest neighbors for each vertex (region).}

\item{w}{A binary adjacency matrix indicating connected neighbors.}

\item{idx}{A vector of vertices for which to construct the set of connected subgraphs.}

\item{nlevel}{The maximum size of each subgraph.}

\item{verbose}{A logical value indicating whether descriptive messages should be provided.  Default is
\code{FALSE}.  If \code{TRUE}, this can be useful for
diagnosing where the sequences of connected subgraphs
is slowing down/having problems.}

\item{logical}{A logical value indicating whether a list of logical vectors should be returned. The default is \code{FALSE},
indicating that the \code{scsg} function should return a list of vectors with
each vector containing the vertex indices included in each subgraph.}
}
\value{
A list with all possible connected subgraphs based on the
user-provided parameters.
}
\description{
\code{csg2}, \code{lcsg2}, and \code{scsg2} construct
connected subgraphs. These functions are not intended
for users.
\code{nn} contains a list of nearest
neighbors for each region. \code{idx} is a
vector of possible vertices being considered as a
subgraph. \code{w} is a connectivity matrix relating the
N vertices. \code{w[i,j] = 1} if vertices i and j are
connected, i.e., if they share an edge. The dimensions of
\code{w} are \eqn{N times k}, where \code{k =
length(idx)}. While the rows of \code{w} contain
adjacency information for all N vertices, only the
\code{idx} columns of the complete adjacency matrix are
used in \code{w}.  See Details for discussion of
\code{scsg}.
}
\details{
\code{scsg2} performs a sequence of \code{lcsg2} calls.
Starting with \code{lcz == list(idx[1])}, \code{scsg}
keeps iteratively building more connected subsgraphs by
perfoming something like:  lcz1 = list(idx[1]).  lcz2 =
lcsg2(lcz1, ...). lcz3 = lcsg2(lcz2, ...).  This is
done until there are no more connected subgraphs among
the elements of \code{idx}.
}
\examples{
data(nydf)
data(nyw)
# determine 50 nn of region 1 for NY data
coords <- as.matrix(nydf[, c("longitude", "latitude")])
nn3 <- knn(coords, longlat = TRUE, k = 3)
z1 <- scsg2(nn3, nyw)
z2 <- flex.zones(coords, nyw, k = 3, longlat = TRUE)
all.equal(z1, z2)
}
