% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.cumsum.R
\name{nn.cumsum}
\alias{nn.cumsum}
\title{Cumulative sum over nearest neighbors}
\usage{
nn.cumsum(nn, y, simplify = TRUE)
}
\arguments{
\item{nn}{A list of nearest neighbors in the format
produced by \code{\link{nnpop}}.}

\item{y}{A numeric vector of values to be summed over.}

\item{simplify}{A logical value indicating whether the
results should be simplified to a numeric vector.  The
default is \code{TRUE}.}
}
\value{
A vector or list, depending on the value of
  \code{simplify}.
}
\description{
\code{nn.cumsum} computes the cumulative sum of \code{y}
for the sequences of indices in each element of the list
contained in \code{nn}.
}
\examples{
# show nn.cumsum example for a circular scan setting
data(nydf)
coords = with(nydf, cbind(longitude, latitude))
cases = floor(nydf$cases)
d = sp::spDists(coords, longlat = TRUE)
# compute circular nearest neigbhors
nn = nnpop(d, pop = nydf$pop, ubpop = 0.1)
# compute cumulative sums over all nn
cnn = nn.cumsum(nn, cases)
# compute cumulative sums over just the first set of nn
cnn1 = cumsum(cases[nn[[1]]])
# check equality
all.equal(cnn1, cnn[seq_along(cnn1)])
}
