% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.factor.gen}
\alias{smbinning.factor.gen}
\title{Utility to generate a new characteristic from a factor variable}
\usage{
smbinning.factor.gen(df, ivout, chrname = "NewChar")
}
\arguments{
\item{df}{Dataset to be updated with the new characteristic.}

\item{ivout}{An object generated after \code{smbinning.factor} or \code{smbinning.factor.custom}.}

\item{chrname}{Name of the new characteristic.}
}
\value{
A data frame with the binned version of the original characteristic.
}
\description{
It generates a data frame with a new predictive characteristic from a factor variable after applying
\code{smbinning.factor} or \code{smbinning.factor.custom}.
}
\examples{
# Training and testing samples (Just some basic formality for Modeling)
pop=chileancredit # Set population
train=subset(pop,Rnd<=0.7) # Training sample
test=subset(pop,Rnd>0.7) # Testing sample
rm(chileancredit) # Remove original dataset

# Binning a factor variable
result=smbinning.factor(train,x="CuWealth",y="FlagGB",maxcat=11)

# Generate a dataset with binned characteristic
popwealth=smbinning.factor.gen(pop,result,"g1CuWealth")

# Check new field counts
table(popwealth$g1CuWealth)
}
