% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.eda}
\alias{smbinning.eda}
\title{Exploratory Data Analysis (EDA)}
\usage{
smbinning.eda(df, rounding = 3, pbar = 1)
}
\arguments{
\item{df}{A data frame.}

\item{rounding}{Optional parameter to define the decimal points shown in the output table. Default is 3.}

\item{pbar}{Optional parameter that turns on or off a progress bar. Default value is 1 (On).}
}
\value{
The command \code{smbinning.eda} generates two data frames that list each characteristic 
with basic statistics such as extreme values and quartiles;
and also percentages of missing values and outliers, among others.
}
\description{
It shows basic statistics for each numeric, integer, and factor characteristic in a data frame.
}
\examples{
# Package loading and data exploration
library(smbinning) # Load package and its data
data(chileancredit) # Load smbinning sample dataset (Chilean Credit)
 
# Training and testing samples (Just some basic formality for Modeling) 
chileancredit.train=subset(chileancredit,FlagSample==1)
chileancredit.test=subset(chileancredit,FlagSample==0)
 
# EDA application
smbinning.eda(chileancredit.train,rounding=3)$eda # Table with basic statistics.
smbinning.eda(chileancredit.train,rounding=3)$edapct # Table with basic percentages.
}

