% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatch.R
\name{s3_dispatch}
\alias{s3_dispatch}
\title{Illustrate S3 dispatch}
\usage{
s3_dispatch(call, env = parent.frame())
}
\arguments{
\item{call}{Example call to S3 method}

\item{env}{Environment in which to evaluate call}
}
\description{
Illustrate S3 dispatch
}
\examples{
x <- Sys.time()
s3_dispatch(print(x))
s3_dispatch(is.numeric(x))
s3_dispatch(as.Date(x))
s3_dispatch(sum(x))

# Internal vs. regular generic
x1 <- 1
x2 <- structure(2, class = "double")

my_length <- function(x) UseMethod("my_length")
s3_dispatch(my_length(x1))
s3_dispatch(my_length(x2))

s3_dispatch(length(x1))
s3_dispatch(length(x2))
}
