% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_map}
\alias{plot_map}
\title{Plot \code{slendr} geographic features on a map}
\usage{
plot_map(
  ...,
  time = NULL,
  gene_flow = FALSE,
  splits = FALSE,
  labels = FALSE,
  graticules = "original",
  intersect = TRUE,
  show_map = TRUE,
  title = NULL,
  interpolated_maps = NULL
)
}
\arguments{
\item{...}{Objects of classes \code{slendr_map}, \code{slendr_region}, or
\code{slendr_pop}}

\item{time}{Plot a concrete time point}

\item{gene_flow}{Indicate gene-flow events with an arrow}

\item{splits}{Indicate split events with lines}

\item{labels}{Should the (starting) polygons of each populations be labeled with
a respective population label (default \code{FALSE})?}

\item{graticules}{Plot graticules in the original Coordinate Reference System
(such as longitude-latitude), or in the internal CRS (such as meters)?}

\item{intersect}{Intersect the population boundaries against landscape and
other geographic boundaries (default \code{TRUE})?}

\item{show_map}{Show the underlying world map}

\item{title}{Title of the plot}

\item{interpolated_maps}{Interpolated spatial boundaries for all populations
in all time points (this is only used for plotting using the \code{explore}
shiny app)}
}
\value{
A ggplot2 object with the visualized slendr map
}
\description{
Plots objects of the three \code{slendr} spatial classes (\code{slendr_map},
\code{slendr_region}, and \code{slendr_pop}).
}
