% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_user_fantasty_points_differential.R
\name{plot_user_fantasy_points_differential}
\alias{plot_user_fantasy_points_differential}
\title{Plot User Fantasy Points Differential}
\usage{
plot_user_fantasy_points_differential(
  league_id,
  display_name,
  title = paste0("<b>Fantasy Point Differential: ", display_name, "</b>"),
  tick_color = "black",
  fill_points_for = "lightgreen",
  fill_points_against = "#f68383"
)
}
\arguments{
\item{league_id}{League ID assigned by Sleeper (numeric).}

\item{display_name}{Display name created by user (string).}

\item{title}{Title for plot, which can include HTML formatting (string).}

\item{tick_color}{Font color, name or hex, for display names (string).}

\item{fill_points_for}{Bar color, name or hex, for bar containing fantasy points for (string).}

\item{fill_points_against}{Bar color, name or hex, for bar containing fantasy points against (string).}
}
\value{
Returns a plot containing the total fantasy points
        differential by user.
}
\description{
Given the league ID and display name, plot the current total fantasy
points for, against, and differential between the two together in one
bar chart.
}
\examples{
\dontrun{plot_user_fantasy_points_differential(688281863499907072, "njbultman74")}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, March 2024
}
\keyword{fantasy}
\keyword{league}
\keyword{points}
\keyword{user}
