% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.skpr_power_curve_output}
\alias{print.skpr_power_curve_output}
\title{Print evaluation information}
\usage{
\method{print}{skpr_power_curve_output}(x, ...)
}
\arguments{
\item{x}{The x of the evaluation functions in skpr}

\item{...}{Additional arguments.}
}
\description{
Prints design evaluation information below the data.frame of power values

Note: If options("skpr.ANSI") is `NULL` or `TRUE`, ANSI codes will be used during printing
to prettify the output. If this is `FALSE`, only ASCII will be used.
}
\examples{
#Generate/evaluate a design and print its information
factorialcoffee = expand.grid(cost = c(1, 2),
                              type = as.factor(c("Kona",
                                                 "Colombian",
                                                 "Ethiopian",
                                                 "Sumatra")),
                              size = as.factor(c("Short",
                                                 "Grande",
                                                 "Venti")))

coffee_curves = calculate_power_curves(candidateset = factorialcoffee,
                                      model = ~(cost + size + type)^2,
                                      trials = 30:40, plot_results = FALSE)
coffee_curves
}
