% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dufour_etal.R
\name{dufour_etal}
\alias{dufour_etal}
\title{Dufour et al.'s Monte Carlo Test for Heteroskedasticity in a Linear
Regression Model}
\usage{
dufour_etal(
  mainlm,
  hettest,
  R = 1000L,
  alternative = c("greater", "less", "two.sided"),
  errorgen = stats::rnorm,
  errorparam = list(),
  seed = 1234,
  ...
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{hettest}{A character specifying the name of a function
that implements a heteroskedasticity test on a linear regression model.
The function is called with the \code{statonly} argument set to
\code{TRUE} to improve computational efficiency.}

\item{R}{An integer specifying the number of Monte Carlo replicates to
generate. Defaults to \code{1000}.}

\item{alternative}{The tailedness of the test whose statistic is computed by
\code{hettest} function; one of \code{"greater"} (the default),
\code{"less"}, or \code{"two.sided"}.}

\item{errorgen}{A function, or a character specifying the name of a
function, from which the random errors are to be generated. The function
should correspond to a continuous probability distribution that has (or
at least can have) a mean of 0. Defaults to \code{\link[stats]{rnorm}}.}

\item{errorparam}{An optional list of parameters to pass to \code{errorgen}.
This argument is ignored if \code{errorgen} is
\code{\link[stats]{rnorm}}, since \code{mean} must be set to 0, and
\code{sd} is set to 1 because the heteroskedasticity test implemented by
\code{hettest} function is assumed to be scale invariant. If
\code{errorgen} is not \code{rnorm}, \code{errorparam} should be chosen
in such a way that the error distribution has a mean of 0.}

\item{seed}{An integer specifying a seed to pass to
\code{\link[base]{set.seed}} for random number generation. This allows
reproducibility of Monte Carlo results. A value of \code{NA}
results in not setting a seed.}

\item{...}{Additional arguments to pass to function with name \code{hettest}}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object
   is not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the method of
   \insertCite{Dufour04;textual}{skedastic} for testing for
   heteroskedasticity in a linear regression model.
}
\details{
The test implements a Monte Carlo procedure as follows. (1) The observed
   value of the test statistic \eqn{T_0} is computed using function
   with name \code{hettest}. (2) \code{R} replications of the random error
   vector are generated from the distribution specified using
   \code{errorgen}. (3) \code{R} replications of the test statistic,
   \eqn{T_1,T_2,\ldots,T_R}, are computed from the generated error vectors.
   (4) The empirical \code{p}-value is computed as
   \eqn{\frac{\hat{G}_R(T_0)+1}{R+1}}, where
   \eqn{\hat{G}_R(x)=\sum_{j=1}^{R} 1_{T_j \ge x}}, \eqn{1_{\bullet}}
   being the indicator function. The test is right-tailed, regardless of the
   tailedness of \code{hettest}. Note that the heteroskedasticity
   test implemented by \code{hettest} must have a test statistic that is
   continuous and that is invariant with respect to nuisance parameters
   (\eqn{\sigma^2} and \eqn{\beta}). Note further that if \code{hettest}
   is \code{goldfeld_quandt} with \code{method} argument
   \code{"parametric"}, the replicated Goldfeld-Quandt \eqn{F} statistics
   are computed directly within this function rather than by calling
   \code{goldfeld_quandt}, due to some idiosyncratic features of this test.
   Note that, if \code{alternative} is set to \code{"two.sided"}, the
   one-sided \eqn{p}-value is doubled (\code{\link{twosidedpval}} cannot
   be used in this case).
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
dufour_etal(mtcars_lm, hettest = "breusch_pagan")

}
\references{
{\insertAllCited{}}
}
