% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descr.R
\name{descr}
\alias{descr}
\title{Basic descriptive statistics}
\usage{
descr(
  x,
  ...,
  max.length = NULL,
  weights = NULL,
  show = "all",
  out = c("txt", "viewer", "browser"),
  encoding = "UTF-8",
  file = NULL
)
}
\arguments{
\item{x}{A vector or a data frame. May also be a grouped data frame
(see 'Note' and 'Examples').}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's
select-helpers.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{max.length}{Numeric, indicating the maximum length of variable labels
in the output. If variable names are longer than \code{max.length},
they will be shortened to the last whole word within the first
\code{max.length} chars.}

\item{weights}{Bare name, or name as string, of a variable in \code{x}
that indicates the vector of weights, which will be applied to weight all
observations. Default is \code{NULL}, so no weights are used.}

\item{show}{Character vector, indicating which information (columns) that describe
the data should be returned. May be one or more of \code{"type", "label", "n",
"NA.prc", "mean", "sd", "se", "md", "trimmed", "range", "iqr", "skew"}. There are
two shortcuts: \code{show = "all"} (default) shows all information,
\code{show = "short"} just shows n, missing percentage, mean and standard
deviation.}

\item{out}{Character vector, indicating whether the results should be printed
to console (\code{out = "txt"}) or as HTML-table in the viewer-pane
(\code{out = "viewer"}) or browser (\code{out = "browser"}).}

\item{encoding}{Character vector, indicating the charset encoding used
for variable and value labels. Default is \code{"UTF-8"}. Only used
when \code{out} is not \code{"txt"}.}

\item{file}{Destination file, if the output should be saved as file.
Only used when \code{out} is not \code{"txt"}.}
}
\value{
A data frame with basic descriptive statistics.
}
\description{
This function prints a basic descriptive statistic, including
  variable labels.
}
\note{
\code{data} may also be a grouped data frame (see \code{\link[dplyr]{group_by}})
   with up to two grouping variables. Descriptive tables are created for each
   subgroup then.
}
\examples{
data(efc)
descr(efc, e17age, c160age)

efc$weights <- abs(rnorm(nrow(efc), 1, .3))
descr(efc, c12hour, barthtot, weights = weights)

library(dplyr)
efc \%>\% select(e42dep, e15relat, c172code) \%>\% descr()

# show just a few elements
efc \%>\% select(e42dep, e15relat, c172code) \%>\% descr(show = "short")

# with grouped data frames
efc \%>\%
  group_by(e16sex) \%>\%
  select(e16sex, e42dep, e15relat, c172code) \%>\%
  descr()

# you can select variables also inside 'descr()'
efc \%>\%
  group_by(e16sex, c172code) \%>\%
  descr(e16sex, c172code, e17age, c160age)

# or even use select-helpers
descr(efc, contains("cop"), max.length = 20)

}
