% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_type.R
\name{var_type}
\alias{var_type}
\title{Determine variable type}
\usage{
var_type(x, ..., abbr = FALSE)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{abbr}{Logical, if \code{TRUE}, returns a shortened, abbreviated value
for the variable type (as returned by \code{\link[tibble]{type_sum}}).
If \code{FALSE} (default), a longer "description" is returned.}
}
\value{
The variable type of \code{x}, as character.
}
\description{
This function returns the type of a variable as character. It
             is similar to \code{\link[tibble]{type_sum}}, however, the
             return value is not truncated, and \code{var_type()} works
             on data frames and within pipe-chains.
}
\examples{
data(efc)

var_type(1)
var_type(1L)
var_type("a")

var_type(efc$e42dep)
var_type(to_factor(efc$e42dep))

library(dplyr)
var_type(efc, contains("cop"))

}
