% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overdisp.R
\name{overdisp}
\alias{overdisp}
\title{Check overdispersion of GLMM's}
\usage{
overdisp(x)
}
\arguments{
\item{x}{Fitted mixed effects model (\code{\link[lme4]{merMod}}-class).}
}
\value{
Information on the overdispersion test. If the p-value is larger than
          0.05, no overdispersion is present. A p-value lower than 0.005
          suggests overdispersion.
}
\description{
This function checks generalized linear mixed models for
               overdispersion. Currently, only \code{\link[lme4]{merMod}} objects
               are supported.
}
\details{
This function is based on the code in the
           \href{http://glmm.wikidot.com/faq}{DRAFT r-sig-mixed-models FAQ},
           section \emph{How can I deal with overdispersion in GLMMs?}.
           Note that this function only returns an \emph{approximate} estimate
           of an overdispersion parameter.
}
\references{
\href{http://glmm.wikidot.com/faq}{DRAFT r-sig-mixed-models FAQ}
}

